/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.utils;

import com.github.jsonzou.jmockdata.mockdata.JMockDataManager;
import java.math.BigDecimal;
import java.util.Random;

public class RandomUtil {
    private static Random random = new Random();

    public static Integer randomIntegerNotZero(int bound) {
        int randomInt = random.nextInt(bound);
        return Math.abs(randomInt == 0 ? 1 : randomInt);
    }

    public static Integer randomInteger(int bound) {
        return random.nextInt(bound);
    }

    public static Integer randomInteger(int leftBound, int rightBound) {
        int _rightBound;
        if (leftBound >= rightBound) {
            return leftBound;
        }
        int _leftBound = Math.abs(leftBound);
        if (_leftBound > (_rightBound = Math.abs(rightBound))) {
            _leftBound ^= _rightBound;
            _rightBound = _leftBound ^ _rightBound;
            _leftBound ^= _rightBound;
        }
        int result = Math.abs(random.nextInt() % (_rightBound - _leftBound + 1) + _leftBound);
        if (leftBound >= 0 && rightBound >= 0) {
            return Math.abs(result);
        }
        if (leftBound < 0 && rightBound <= 0) {
            if (leftBound > result) {
                return leftBound * -1 + result;
            }
            return result > 0 ? result * -1 : result;
        }
        if (leftBound < 0 && rightBound >= 0) {
            if (result >= leftBound && result <= rightBound) {
                if (random.nextBoolean() && result > 0 && result * -1 > leftBound) {
                    return result * -1;
                }
                return result;
            }
            return result * -1;
        }
        return result;
    }

    public static Short randomShort(short leftBound, short rightBound) {
        Integer randomInt = RandomUtil.randomInteger(leftBound, rightBound);
        return Short.parseShort(randomInt + "");
    }

    public static Long randomLong(long leftBound, long rightBound) {
        long _rightBound;
        if (leftBound >= rightBound) {
            return leftBound;
        }
        long _leftBound = Math.abs(leftBound);
        if (_leftBound > (_rightBound = Math.abs(rightBound))) {
            _leftBound ^= _rightBound;
            _rightBound = _leftBound ^ _rightBound;
            _leftBound ^= _rightBound;
        }
        long result = Math.abs(random.nextLong() % (_rightBound - _leftBound + 1L) + _leftBound);
        if (leftBound >= 0L && rightBound >= 0L) {
            return Math.abs(result);
        }
        if (leftBound < 0L && rightBound <= 0L) {
            if (leftBound > result) {
                return leftBound * -1L + result;
            }
            return result > 0L ? result * -1L : result;
        }
        if (leftBound < 0L && rightBound >= 0L) {
            if (result >= leftBound && result <= rightBound) {
                if (random.nextBoolean() && result > 0L && result * -1L > leftBound) {
                    return result * -1L;
                }
                return result;
            }
            return result * -1L;
        }
        return result;
    }

    public static Double randomDouble(double leftBound, double rightBound) {
        if (leftBound >= rightBound) {
            return leftBound;
        }
        double result = random.nextDouble() * (rightBound - leftBound) + leftBound;
        BigDecimal bigDecimal = new BigDecimal(result);
        result = bigDecimal.setScale((int)JMockDataManager.getInstance().config().getDecimalScale(), 1).doubleValue();
        if (leftBound >= 0.0 && rightBound >= 0.0) {
            return Math.abs(result);
        }
        return result;
    }

    public static Float randomFloat(float leftBound, float rightBound) {
        if (leftBound >= rightBound) {
            return Float.valueOf(leftBound);
        }
        float result = random.nextFloat() * (rightBound - leftBound) + leftBound;
        BigDecimal bigDecimal = new BigDecimal(result);
        result = bigDecimal.setScale((int)JMockDataManager.getInstance().config().getDecimalScale(), 1).floatValue();
        if (leftBound >= 0.0f && rightBound >= 0.0f) {
            return Float.valueOf(Math.abs(result));
        }
        return Float.valueOf(result);
    }
}

