/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ReflectionUtils;

public class FieldReflectUtil {
    public static <T> void setFieldValue(T target, Field field, Object value) throws Exception {
        ReflectionUtils.makeAccessible((Field)field);
        if (field.getType().isPrimitive()) {
            // empty if block
        }
        if (value == null) {
            field.set(target, null);
            return;
        }
        field.set(target, value);
    }

    public static <T> Object getFieldValue(T target, Field field) throws Exception {
        ReflectionUtils.makeAccessible((Field)field);
        if (field.get(target) == null) {
            return null;
        }
        if (field.getType().isEnum()) {
            // empty if block
        }
        return field.get(target);
    }

    public static Field findField(Class<?> clazz, Class<? extends Annotation> annotationType) {
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotationType)) continue;
                return field;
            }
        }
        return null;
    }

    public static List<Field> getAllField(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                list.add(field);
            }
        }
        return list;
    }
}

