/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.core;

import com.mybatis.jpa.annotation.MapperDefinition;
import com.mybatis.jpa.common.scanner.AnnotationTypeFilterBuilder;
import com.mybatis.jpa.common.scanner.SpringClassScanner;
import com.mybatis.jpa.core.PersistentMapperEnhancer;
import com.mybatis.jpa.core.PersistentResultMapEnhancer;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Entity;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.annotation.MethodResolver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.type.filter.TypeFilter;

public class PersistentEnhancerScaner
implements ApplicationListener<ApplicationEvent> {
    private String mapperPackage;
    private String entityPackage;
    private SqlSessionFactory sqlSessionFactory;

    public void setMapperPackage(String mapperPackage) {
        this.mapperPackage = mapperPackage;
    }

    public void setEntityPackage(String entityPackage) {
        this.entityPackage = entityPackage;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!(event instanceof ContextRefreshedEvent)) {
            return;
        }
        if (((ContextRefreshedEvent)event).getApplicationContext().getParent() != null) {
            return;
        }
        Configuration configuration = this.sqlSessionFactory.getConfiguration();
        TypeFilter entityFilter = AnnotationTypeFilterBuilder.build(Entity.class);
        SpringClassScanner entityScanner = new SpringClassScanner.Builder().scanPackage(this.entityPackage).typeFilter(entityFilter).build();
        Set<Class<?>> entitySet = null;
        try {
            entitySet = entityScanner.scan();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (entitySet != null && !entitySet.isEmpty()) {
            for (Class<?> entity : entitySet) {
                PersistentResultMapEnhancer resultMapEnhancer = new PersistentResultMapEnhancer(configuration, entity);
                resultMapEnhancer.enhance();
            }
        }
        TypeFilter typeFilter = AnnotationTypeFilterBuilder.build(MapperDefinition.class);
        SpringClassScanner scanner = new SpringClassScanner.Builder().scanPackage(this.mapperPackage).typeFilter(typeFilter).build();
        Set<Class<?>> mapperSet = null;
        try {
            mapperSet = scanner.scan();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (mapperSet != null && !mapperSet.isEmpty()) {
            for (Class<?> mapper : mapperSet) {
                PersistentMapperEnhancer mapperEnhancer = new PersistentMapperEnhancer(configuration, mapper);
                mapperEnhancer.enhance();
            }
            this.parsePendingMethods(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingMethods(Configuration configuration) {
        Collection incompleteMethods;
        Collection collection = incompleteMethods = configuration.getIncompleteMethods();
        synchronized (collection) {
            Iterator iter = incompleteMethods.iterator();
            while (iter.hasNext()) {
                try {
                    ((MethodResolver)iter.next()).resolve();
                    iter.remove();
                }
                catch (IncompleteElementException e) {}
            }
        }
    }
}

