/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.core;

import com.mybatis.jpa.common.AssociationUtil;
import com.mybatis.jpa.common.PersistentUtil;
import com.mybatis.jpa.meta.MybatisColumnMeta;
import com.mybatis.jpa.meta.PersistentMeta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.ResultMapResolver;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class PersistentResultMapEnhancer
extends BaseBuilder {
    protected MapperBuilderAssistant assistant;
    protected String namespace;
    protected Class<?> type;
    protected PersistentMeta persistentMeta;

    public PersistentResultMapEnhancer(Configuration configuration, Class<?> type) {
        super(configuration);
        String resource = "jpa.result.map".replaceAll(".", "/") + ".java (best guess)";
        this.assistant = new MapperBuilderAssistant(configuration, resource);
        this.type = type;
        this.persistentMeta = new PersistentMeta(type);
    }

    public void enhance() {
        String resource = "interface jpa.result.map";
        if (!this.configuration.isResourceLoaded(resource)) {
            this.configuration.addLoadedResource(resource);
        }
        this.assistant.setCurrentNamespace("jpa.result.map");
        if (!this.type.isAnnotationPresent(Entity.class)) {
            return;
        }
        ResultMapAdapter.parseResultMap(this.assistant, this.persistentMeta);
    }

    private static class ResultMapAdapter {
        private ResultMapAdapter() {
        }

        static void parseResultMap(MapperBuilderAssistant assistant, PersistentMeta persistentMeta) {
            Class<?> resultType = persistentMeta.getType();
            String id = persistentMeta.getEntityName();
            if (assistant.getConfiguration().getResultMapNames().contains(id)) {
                return;
            }
            String extend = null;
            Boolean autoMapping = false;
            Discriminator discriminator = null;
            List<Field> fields = PersistentUtil.getPersistentFields(resultType);
            ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>(fields.size() + 1);
            for (MybatisColumnMeta columnMeta : persistentMeta.getColumnMetaMap().values()) {
                String property = columnMeta.getProperty();
                String column = columnMeta.getColumnName();
                Class<?> javaType = columnMeta.getType();
                JdbcType jdbcType = columnMeta.getJdbcType();
                String nestedSelect = null;
                String nestedResultMap = null;
                String notNullColumn = null;
                String columnPrefix = null;
                String resultSet = null;
                String foreignColumn = null;
                ArrayList flags = new ArrayList();
                boolean lazy = false;
                Class<? extends TypeHandler<?>> typeHandlerClass = columnMeta.getTypeHandlerClass();
                ResultMapping resultMapping = assistant.buildResultMapping(resultType, property, column, javaType, jdbcType, nestedSelect, nestedResultMap, notNullColumn, columnPrefix, typeHandlerClass, flags, resultSet, foreignColumn, lazy);
                resultMappings.add(resultMapping);
            }
            List<Field> associationFields = AssociationUtil.getAssociationFields(resultType);
            if (!associationFields.isEmpty()) {
                for (Field field : associationFields) {
                    String property = field.getName();
                    String column = AssociationUtil.getMappedName(field);
                    Class<?> javaType = AssociationUtil.getTargetType(field);
                    JdbcType jdbcType = null;
                    String nestedSelect = null;
                    String nestedResultMap = assistant.getCurrentNamespace() + "." + PersistentUtil.getEntityName(javaType);
                    String notNullColumn = null;
                    String columnPrefix = null;
                    String resultSet = null;
                    String foreignColumn = null;
                    ArrayList flags = new ArrayList();
                    boolean lazy = false;
                    Class typeHandlerClass = null;
                    ResultMapping resultMapping = assistant.buildResultMapping(resultType, property, column, javaType, jdbcType, nestedSelect, nestedResultMap, notNullColumn, columnPrefix, typeHandlerClass, flags, resultSet, foreignColumn, lazy);
                    resultMappings.add(resultMapping);
                }
            }
            ResultMapResolver resultMapResolver = new ResultMapResolver(assistant, id, resultType, extend, discriminator, resultMappings, autoMapping);
            try {
                resultMapResolver.resolve();
            }
            catch (IncompleteElementException e) {
                assistant.getConfiguration().addIncompleteResultMap(resultMapResolver);
                throw e;
            }
        }
    }
}

