/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.meta;

import com.mybatis.jpa.common.PersistentUtil;
import java.lang.reflect.Field;
import java.util.Date;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.type.BooleanTypeHandler;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class MybatisColumnMeta {
    private boolean primaryKey;
    private String property;
    private String columnName;
    private Class<?> type;
    private String jdbcTypeAlias;
    private JdbcType jdbcType;
    private Class<? extends TypeHandler<?>> typeHandlerClass;
    private Field field;

    public MybatisColumnMeta(Field field) {
        this.field = field;
        this.property = field.getName();
        this.columnName = PersistentUtil.getColumnName(field);
        this.type = field.getType();
        this.jdbcTypeAlias = ColumnMetaResolver.resolveJdbcAlias(field);
        this.jdbcType = ColumnMetaResolver.resolveJdbcType(this.jdbcTypeAlias);
        this.typeHandlerClass = ColumnMetaResolver.resolveTypeHandler(field);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getProperty() {
        return this.property;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getJdbcTypeAlias() {
        return this.jdbcTypeAlias;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<? extends TypeHandler<?>> getTypeHandlerClass() {
        return this.typeHandlerClass;
    }

    public Field getField() {
        return this.field;
    }

    private static class ColumnMetaResolver {
        private ColumnMetaResolver() {
        }

        public static String resolveJdbcAlias(Field field) {
            Class<?> fieldType = field.getType();
            if (field.getType().isEnum()) {
                Enumerated enumerated;
                if (field.isAnnotationPresent(Enumerated.class) && (enumerated = field.getAnnotation(Enumerated.class)).value() == EnumType.ORDINAL) {
                    return "INTEGER";
                }
                return "VARCHAR";
            }
            if (field.isAnnotationPresent(Lob.class) && String.class.equals(fieldType)) {
                return "CLOB";
            }
            if (Integer.class.equals(fieldType)) {
                return "INTEGER";
            }
            if (Double.class.equals(fieldType)) {
                return "DOUBLE";
            }
            if (Float.class.equals(fieldType)) {
                return "FLOAT";
            }
            if (String.class.equals(fieldType)) {
                return "VARCHAR";
            }
            if (Date.class.isAssignableFrom(fieldType)) {
                return "TIMESTAMP";
            }
            return null;
        }

        public static JdbcType resolveJdbcType(String alias) {
            if (alias == null) {
                return null;
            }
            try {
                return JdbcType.valueOf((String)alias);
            }
            catch (IllegalArgumentException e) {
                throw new BuilderException("Error resolving JdbcType. Cause: " + e, (Throwable)e);
            }
        }

        public static Class<? extends TypeHandler<?>> resolveTypeHandler(Field field) {
            if (field.getType().isEnum()) {
                Enumerated enumerated;
                if (field.isAnnotationPresent(Enumerated.class) && (enumerated = field.getAnnotation(Enumerated.class)).value() == EnumType.ORDINAL) {
                    EnumOrdinalTypeHandler typeHandler = new EnumOrdinalTypeHandler(field.getClass());
                    return typeHandler.getClass();
                }
                EnumTypeHandler typeHandler = new EnumTypeHandler(field.getClass());
                return typeHandler.getClass();
            }
            Class<BooleanTypeHandler> typeHandlerClass = null;
            if (field.getType().equals(Boolean.class)) {
                typeHandlerClass = BooleanTypeHandler.class;
            }
            return typeHandlerClass;
        }
    }
}

