/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.meta;

import com.mybatis.jpa.common.PersistentUtil;
import com.mybatis.jpa.meta.MybatisColumnMeta;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PersistentMeta {
    private Class<?> type;
    private String tableName;
    private String entityName;
    private MybatisColumnMeta primaryColumnMeta;
    private List<String> columnNameCollection;
    private String columnNames;
    private Map<String, MybatisColumnMeta> columnMetaMap;

    public PersistentMeta(Class<?> type) {
        this.type = type;
        this.persistence();
    }

    private void persistence() {
        this.tableName = PersistentUtil.getTableName(this.type);
        this.entityName = PersistentUtil.getEntityName(this.type);
        this.primaryColumnMeta = new MybatisColumnMeta(PersistentUtil.getPrimaryField(this.type));
        List<Field> fields = PersistentUtil.getPersistentFields(this.type);
        this.columnNameCollection = new ArrayList<String>();
        this.columnMetaMap = new LinkedHashMap<String, MybatisColumnMeta>();
        StringBuilder columnNamesTemp = new StringBuilder();
        for (Field field : fields) {
            MybatisColumnMeta columnMeta = new MybatisColumnMeta(field);
            this.columnMetaMap.put(field.getName(), columnMeta);
            this.columnNameCollection.add(columnMeta.getColumnName());
            columnNamesTemp.append(",").append(columnMeta.getColumnName());
        }
        this.columnNames = columnNamesTemp.substring(1);
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public MybatisColumnMeta getPrimaryColumnMeta() {
        return this.primaryColumnMeta;
    }

    public List<String> getColumnNameCollection() {
        return this.columnNameCollection;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public Map<String, MybatisColumnMeta> getColumnMetaMap() {
        return this.columnMetaMap;
    }
}

