/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.statement;

import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.scripting.LanguageDriver;

public class MybatisStatementAdapter {
    private MapperBuilderAssistant assistant;
    private LanguageDriver languageDriver;
    private String methodName;
    private Class<?> parameterTypeClass;
    private String sqlScript;
    private Integer fetchSize;
    private Integer timeout;
    private StatementType statementType;
    private ResultSetType resultSetType;
    private SqlCommandType sqlCommandType;
    private KeyGenerator keyGenerator;
    private String keyProperty;
    private String keyColumn;
    String resultMapId;
    private Class<?> resultType;

    protected MybatisStatementAdapter() {
    }

    public MybatisStatementAdapter(MapperBuilderAssistant assistant) {
        this.assistant = assistant;
        this.initParameters();
    }

    private void initParameters() {
        this.languageDriver = this.assistant.getLanguageDriver(null);
        this.statementType = StatementType.PREPARED;
        this.resultSetType = ResultSetType.FORWARD_ONLY;
    }

    public final void parseStatement() {
        SqlSource sqlSource = this.buildSqlSource(this.sqlScript, this.parameterTypeClass);
        if (sqlSource != null) {
            String mappedStatementId = this.getMappedStatementId();
            boolean isSelect = this.sqlCommandType == SqlCommandType.SELECT;
            boolean flushCache = !isSelect;
            boolean useCache = isSelect;
            this.assistant.addMappedStatement(mappedStatementId, sqlSource, this.statementType, this.sqlCommandType, this.fetchSize, this.timeout, null, this.parameterTypeClass, this.resultMapId, this.resultType, this.resultSetType, flushCache, useCache, false, this.keyGenerator, this.keyProperty, this.keyColumn, null, this.languageDriver, null);
        }
    }

    private String getMappedStatementId() {
        String currentNamespace = this.assistant.getCurrentNamespace();
        if (currentNamespace == null || currentNamespace.trim().equals("")) {
            // empty if block
        }
        if (this.methodName == null || this.methodName.trim().equals("")) {
            // empty if block
        }
        return currentNamespace + "." + this.methodName;
    }

    private SqlSource buildSqlSource(String sqlScript, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        return languageDriver.createSqlSource(this.assistant.getConfiguration(), sqlScript, parameterTypeClass);
    }

    private SqlSource buildSqlSource(String sqlScript, Class<?> parameterTypeClass) {
        return this.buildSqlSource(sqlScript, parameterTypeClass, this.languageDriver);
    }

    public MapperBuilderAssistant getAssistant() {
        return this.assistant;
    }

    public void setAssistant(MapperBuilderAssistant assistant) {
        this.assistant = assistant;
    }

    public LanguageDriver getLanguageDriver() {
        return this.languageDriver;
    }

    public void setLanguageDriver(LanguageDriver languageDriver) {
        this.languageDriver = languageDriver;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Class<?> getParameterTypeClass() {
        return this.parameterTypeClass;
    }

    public void setParameterTypeClass(Class<?> parameterTypeClass) {
        this.parameterTypeClass = parameterTypeClass;
    }

    public String getSqlScript() {
        return this.sqlScript;
    }

    public void setSqlScript(String sqlScript) {
        this.sqlScript = sqlScript;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public ResultSetType getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(ResultSetType resultSetType) {
        this.resultSetType = resultSetType;
    }

    public SqlCommandType getSqlCommandType() {
        return this.sqlCommandType;
    }

    public void setSqlCommandType(SqlCommandType sqlCommandType) {
        this.sqlCommandType = sqlCommandType;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public void setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public static class Builder {
        private MybatisStatementAdapter adapter = new MybatisStatementAdapter();

        public Builder assistant(MapperBuilderAssistant assistant) {
            this.adapter.assistant = assistant;
            return this;
        }

        public Builder languageDriver(LanguageDriver languageDriver) {
            this.adapter.languageDriver = languageDriver;
            return this;
        }

        public Builder methodName(String methodName) {
            this.adapter.methodName = methodName;
            return this;
        }

        public Builder parameterTypeClass(Class<?> parameterTypeClass) {
            this.adapter.parameterTypeClass = parameterTypeClass;
            return this;
        }

        public Builder sqlScript(String sqlScript) {
            this.adapter.sqlScript = sqlScript;
            return this;
        }

        public Builder fetchSize(Integer fetchSize) {
            this.adapter.fetchSize = fetchSize;
            return this;
        }

        public Builder methodName(Integer timeout) {
            this.adapter.timeout = timeout;
            return this;
        }

        public Builder statementType(StatementType statementType) {
            this.adapter.statementType = statementType;
            return this;
        }

        public Builder sqlCommandType(SqlCommandType sqlCommandType) {
            this.adapter.sqlCommandType = sqlCommandType;
            return this;
        }

        public Builder keyGenerator(KeyGenerator keyGenerator) {
            this.adapter.keyGenerator = keyGenerator;
            return this;
        }

        public Builder keyProperty(String keyProperty) {
            this.adapter.keyProperty = keyProperty;
            return this;
        }

        public Builder keyColumn(String keyColumn) {
            this.adapter.keyColumn = keyColumn;
            return this;
        }

        public Builder resultMapId(String resultMapId) {
            this.adapter.resultMapId = resultMapId;
            return this;
        }

        public Builder resultType(Class<?> resultType) {
            this.adapter.resultType = resultType;
            return this;
        }

        public MybatisStatementAdapter build() {
            return this.adapter;
        }
    }
}

