/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.statement.builder;

import com.mybatis.jpa.meta.MybatisColumnMeta;
import com.mybatis.jpa.meta.PersistentMeta;
import com.mybatis.jpa.statement.MybatisStatementAdapter;
import com.mybatis.jpa.statement.SqlAssistant;
import com.mybatis.jpa.statement.builder.StatementBuildable;
import java.lang.reflect.Method;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.SqlCommandType;

public class BatchInsertBuilder
implements StatementBuildable {
    @Override
    public String buildSQL(PersistentMeta persistentMeta, Method method) {
        StringBuilder values = new StringBuilder();
        for (MybatisColumnMeta columnMeta : persistentMeta.getColumnMetaMap().values()) {
            if (values.length() > 0) {
                values.append(",");
            }
            values.append(SqlAssistant.resolveSqlParameter(columnMeta, "rowData"));
        }
        return "<script> INSERT INTO " + persistentMeta.getTableName() + " (" + persistentMeta.getColumnNames() + " ) " + " VALUES " + "<foreach item='rowData' index='rowIndex' collection='list' separator=','>" + "( " + values.toString() + " )" + "</foreach>" + "</script>";
    }

    @Override
    public void parseStatement(MybatisStatementAdapter adapter, PersistentMeta persistentMeta, Method method) {
        adapter.setMethodName(method.getName());
        adapter.setParameterTypeClass(persistentMeta.getClass());
        adapter.setSqlScript(this.buildSQL(persistentMeta, method));
        adapter.setResultType(Integer.TYPE);
        adapter.setResultMapId(null);
        adapter.setSqlCommandType(SqlCommandType.INSERT);
        adapter.setKeyGenerator((KeyGenerator)new NoKeyGenerator());
        adapter.setKeyProperty(null);
        adapter.setKeyColumn(null);
        adapter.parseStatement();
    }
}

