/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.statement.builder;

import com.mybatis.jpa.meta.MybatisColumnMeta;
import com.mybatis.jpa.meta.PersistentMeta;
import com.mybatis.jpa.statement.MybatisStatementAdapter;
import com.mybatis.jpa.statement.SqlAssistant;
import com.mybatis.jpa.statement.builder.StatementBuildable;
import java.lang.reflect.Method;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.SqlCommandType;

public class InsertSelectiveBuilder
implements StatementBuildable {
    @Override
    public String buildSQL(PersistentMeta persistentMeta, Method method) {
        StringBuilder columns = new StringBuilder();
        columns.append("<trim prefix='(' suffix=')' suffixOverrides=',' > ");
        StringBuilder values = new StringBuilder();
        values.append("<trim prefix='(' suffix=')' suffixOverrides=',' > ");
        for (MybatisColumnMeta columnMeta : persistentMeta.getColumnMetaMap().values()) {
            columns.append("<if test='" + columnMeta.getProperty() + "!= null'> ");
            columns.append(columnMeta.getColumnName() + ", ");
            columns.append("</if> ");
            values.append("<if test='" + columnMeta.getProperty() + "!= null'> ");
            values.append(SqlAssistant.resolveSqlParameter(columnMeta) + ", ");
            values.append("</if> ");
        }
        columns.append("</trim> ");
        values.append("</trim> ");
        return "<script>INSERT INTO " + persistentMeta.getTableName() + columns.toString() + " VALUES " + values.toString() + "</script>";
    }

    @Override
    public void parseStatement(MybatisStatementAdapter adapter, PersistentMeta persistentMeta, Method method) {
        adapter.setMethodName(method.getName());
        adapter.setParameterTypeClass(persistentMeta.getType());
        adapter.setSqlScript(this.buildSQL(persistentMeta, method));
        adapter.setResultType(Integer.TYPE);
        adapter.setResultMapId(null);
        adapter.setSqlCommandType(SqlCommandType.INSERT);
        adapter.setKeyGenerator((KeyGenerator)new NoKeyGenerator());
        adapter.setKeyProperty(null);
        adapter.setKeyColumn(null);
        adapter.parseStatement();
    }
}

