/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.statement.builder;

import com.mybatis.jpa.meta.PersistentMeta;
import com.mybatis.jpa.statement.MybatisStatementAdapter;
import com.mybatis.jpa.statement.SqlAssistant;
import com.mybatis.jpa.statement.builder.StatementBuildable;
import java.lang.reflect.Method;
import javax.persistence.OrderBy;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.SqlCommandType;

public class SelectBuilder
implements StatementBuildable {
    @Override
    public String buildSQL(PersistentMeta persistentMeta, Method method) {
        return "SELECT " + persistentMeta.getColumnNames() + " FROM " + persistentMeta.getTableName() + SqlAssistant.buildSingleCondition(method, persistentMeta);
    }

    @Override
    public void parseStatement(MybatisStatementAdapter adapter, PersistentMeta persistentMeta, Method method) {
        adapter.setMethodName(method.getName());
        if (method.getParameterTypes().length > 0) {
            adapter.setParameterTypeClass(Object.class);
        } else {
            adapter.setParameterTypeClass(Void.TYPE);
        }
        String orderBy = " ";
        if (method.isAnnotationPresent(OrderBy.class)) {
            orderBy = " order by " + method.getAnnotation(OrderBy.class).value();
        }
        adapter.setSqlScript(this.buildSQL(persistentMeta, method) + orderBy);
        adapter.setResultType(persistentMeta.getType());
        adapter.setResultMapId("jpa.result.map." + persistentMeta.getEntityName());
        adapter.setSqlCommandType(SqlCommandType.SELECT);
        adapter.setKeyGenerator((KeyGenerator)new NoKeyGenerator());
        adapter.setKeyProperty(null);
        adapter.setKeyColumn(null);
        adapter.parseStatement();
    }
}

