/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.jpa.statement.builder;

import com.mybatis.jpa.meta.MybatisColumnMeta;
import com.mybatis.jpa.meta.PersistentMeta;
import com.mybatis.jpa.statement.MybatisStatementAdapter;
import com.mybatis.jpa.statement.SqlAssistant;
import com.mybatis.jpa.statement.builder.StatementBuildable;
import java.lang.reflect.Method;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.SqlCommandType;

public class UpdateSelectiveBuilder
implements StatementBuildable {
    @Override
    public String buildSQL(PersistentMeta persistentMeta, Method method) {
        StringBuilder sets = new StringBuilder();
        sets.append("<trim prefix='' suffix='' suffixOverrides=',' > ");
        for (MybatisColumnMeta columnMeta : persistentMeta.getColumnMetaMap().values()) {
            sets.append("<if test='" + columnMeta.getProperty() + "!= null'> ");
            sets.append(columnMeta.getColumnName()).append(" = ").append(SqlAssistant.resolveSqlParameter(columnMeta)).append(" , ");
            sets.append("</if> ");
        }
        sets.append("</trim> ");
        return "<script>UPDATE " + persistentMeta.getTableName() + " set " + sets.toString() + SqlAssistant.buildSingleCondition(method, persistentMeta) + "</script>";
    }

    @Override
    public void parseStatement(MybatisStatementAdapter adapter, PersistentMeta persistentMeta, Method method) {
        adapter.setMethodName(method.getName());
        adapter.setParameterTypeClass(persistentMeta.getType());
        adapter.setSqlScript(this.buildSQL(persistentMeta, method));
        adapter.setResultType(Integer.TYPE);
        adapter.setResultMapId(null);
        adapter.setSqlCommandType(SqlCommandType.UPDATE);
        adapter.setKeyGenerator((KeyGenerator)new NoKeyGenerator());
        adapter.setKeyProperty(null);
        adapter.setKeyColumn(null);
        adapter.parseStatement();
    }
}

