/*
 * Decompiled with CFR 0.152.
 */
package com.github.mxab.thymeleaf.extras.dataattribute.dialect;

import org.attoparser.util.TextUtil;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.element.IElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.NoOpToken;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.EscapedAttributeUtils;
import org.unbescape.html.HtmlEscape;

public class DataProcessor
extends AbstractProcessor
implements IElementTagProcessor {
    public static final int PRECEDENCE = Integer.MAX_VALUE;
    private final String dialectPrefix;
    private final MatchingAttributeName matchingAttributeName;

    public DataProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, Integer.MAX_VALUE);
        this.dialectPrefix = dialectPrefix;
        this.matchingAttributeName = MatchingAttributeName.forAllAttributesWithPrefix((TemplateMode)this.getTemplateMode(), (String)dialectPrefix);
    }

    public MatchingElementName getMatchingElementName() {
        return null;
    }

    public MatchingAttributeName getMatchingAttributeName() {
        return this.matchingAttributeName;
    }

    public void process(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        IAttribute[] attributes;
        TemplateMode templateMode = this.getTemplateMode();
        for (IAttribute attribute : attributes = tag.getAllAttributes()) {
            AttributeName attributeName = attribute.getAttributeDefinition().getAttributeName();
            if (!attributeName.isPrefixed() || !TextUtil.equals((boolean)templateMode.isCaseSensitive(), (CharSequence)attributeName.getPrefix(), (CharSequence)this.dialectPrefix)) continue;
            this.processDataAttribute(context, tag, attribute, structureHandler);
        }
    }

    private void processDataAttribute(ITemplateContext context, IProcessableElementTag tag, IAttribute attribute, IElementTagStructureHandler structureHandler) {
        try {
            Object expressionResult;
            AttributeName attributeName = attribute.getAttributeDefinition().getAttributeName();
            String attributeValue = EscapedAttributeUtils.unescapeAttribute((TemplateMode)context.getTemplateMode(), (String)attribute.getValue());
            String originalCompleteAttributeName = attribute.getAttributeCompleteName();
            String canonicalAttributeName = attributeName.getAttributeName();
            String newAttributeName = "data-";
            newAttributeName = TextUtil.endsWith((boolean)true, (CharSequence)originalCompleteAttributeName, (CharSequence)canonicalAttributeName) ? newAttributeName + canonicalAttributeName : newAttributeName + originalCompleteAttributeName.substring(originalCompleteAttributeName.length() - canonicalAttributeName.length());
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)context.getConfiguration());
            if (attributeValue != null) {
                IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)context, attributeValue);
                expressionResult = expression.execute((IExpressionContext)context);
            } else {
                expressionResult = null;
            }
            if (expressionResult == NoOpToken.VALUE) {
                structureHandler.removeAttribute(attributeName);
                return;
            }
            String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? null : expressionResult.toString()));
            if (newAttributeValue == null || newAttributeValue.length() == 0) {
                structureHandler.removeAttribute(newAttributeName);
                structureHandler.removeAttribute(attributeName);
            } else {
                structureHandler.replaceAttribute(attributeName, newAttributeName, newAttributeValue == null ? "" : newAttributeValue);
            }
        }
        catch (TemplateProcessingException e) {
            if (!e.hasTemplateName()) {
                e.setTemplateName(tag.getTemplateName());
            }
            if (!e.hasLineAndCol()) {
                e.setLineAndCol(attribute.getLine(), attribute.getCol());
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + ((Object)((Object)this)).getClass().getName() + "'", tag.getTemplateName(), attribute.getLine(), attribute.getCol(), (Throwable)e);
        }
    }
}

