/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

public class JsonFormatUtil {
    public static String formatJson(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char current = '\u0000';
        int indent = 0;
        block6: for (int i = 0; i < jsonStr.length(); ++i) {
            char last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '[': 
                case '{': {
                    sb.append(current);
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, ++indent);
                    continue block6;
                }
                case ']': 
                case '}': {
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, --indent);
                    sb.append(current);
                    continue block6;
                }
                case ',': {
                    sb.append(current);
                    if (last == '\\') continue block6;
                    sb.append('\n');
                    JsonFormatUtil.addIndentBlank(sb, indent);
                    continue block6;
                }
                case ':': {
                    if (last != '\\' && last == '\"') {
                        sb.append(current).append(" ");
                        continue block6;
                    }
                    sb.append(current);
                    continue block6;
                }
                default: {
                    sb.append(current);
                }
            }
        }
        return sb.toString();
    }

    private static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }
}

