/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.DateTimeUtil;
import com.power.common.util.FileUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.DocGlobalConstants;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiDocDict;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.template.SpringBootDocBuildTemplate;
import com.power.doc.utils.BeetlTemplateUtil;
import com.power.doc.utils.MarkDownUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.beetl.core.Template;

public class HtmlApiDocBuilder {
    private static long now = System.currentTimeMillis();
    private static final String STR_TIME = DateTimeUtil.long2Str((long)now, (String)"yyyy-MM-dd HH:mm:ss");
    private static String INDEX_HTML = "index.html";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        HtmlApiDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        SpringBootDocBuildTemplate docBuildTemplate = new SpringBootDocBuildTemplate();
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            Template indexCssTemplate = BeetlTemplateUtil.getByName("AllInOne.css");
            FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "AllInOne.css"));
            if (StringUtils.isNotEmpty((CharSequence)config.getAllInOneDocFileName())) {
                INDEX_HTML = config.getAllInOneDocFileName();
            }
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.html", INDEX_HTML);
        } else {
            List<ApiDocDict> apiDocDictList = builderTemplate.buildDictionary(config, javaProjectBuilder);
            HtmlApiDocBuilder.buildIndex(apiDocList, config);
            HtmlApiDocBuilder.copyCss(config.getOutPath());
            HtmlApiDocBuilder.buildDoc(apiDocList, config);
            HtmlApiDocBuilder.buildErrorCodeDoc(config.getErrorCodes(), config.getOutPath());
            HtmlApiDocBuilder.buildDictionary(apiDocDictList, config.getOutPath());
        }
    }

    private static void copyCss(String outPath) {
        Template indexCssTemplate = BeetlTemplateUtil.getByName("index.css");
        Template mdCssTemplate = BeetlTemplateUtil.getByName("markdown.css");
        FileUtil.nioWriteFile((String)indexCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "index.css"));
        FileUtil.nioWriteFile((String)mdCssTemplate.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "markdown.css"));
    }

    private static void buildIndex(List<ApiDoc> apiDocList, ApiConfig config) {
        FileUtil.mkdirs((String)config.getOutPath());
        Template indexTemplate = BeetlTemplateUtil.getByName("Index.btl");
        if (CollectionUtil.isEmpty(apiDocList)) {
            return;
        }
        ApiDoc doc = apiDocList.get(0);
        String homePage = doc.getAlias();
        indexTemplate.binding(TemplateVariable.HOME_PAGE.getVariable(), (Object)homePage);
        indexTemplate.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        indexTemplate.binding(TemplateVariable.API_DOC_LIST.getVariable(), apiDocList);
        indexTemplate.binding(TemplateVariable.ERROR_CODE_LIST.getVariable(), config.getErrorCodes());
        indexTemplate.binding(TemplateVariable.DICT_LIST.getVariable(), config.getDataDictionaries());
        if (CollectionUtil.isEmpty(config.getErrorCodes())) {
            indexTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 1));
        } else {
            indexTemplate.binding(TemplateVariable.DICT_ORDER.getVariable(), (Object)(apiDocList.size() + 2));
        }
        if (null != config.getLanguage()) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
                indexTemplate.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
            } else {
                indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
                indexTemplate.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"Data Dictionaries");
            }
        } else {
            indexTemplate.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            indexTemplate.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
        }
        FileUtil.nioWriteFile((String)indexTemplate.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + "api.html"));
    }

    private static void buildDoc(List<ApiDoc> apiDocList, ApiConfig config) {
        FileUtil.mkdirs((String)config.getOutPath());
        for (ApiDoc doc : apiDocList) {
            Template apiTemplate = BeetlTemplateUtil.getByName("ApiDoc.btl");
            apiTemplate.binding(TemplateVariable.REQUEST_EXAMPLE.getVariable(), (Object)config.isRequestExample());
            apiTemplate.binding(TemplateVariable.RESPONSE_EXAMPLE.getVariable(), (Object)config.isResponseExample());
            apiTemplate.binding(TemplateVariable.DESC.getVariable(), (Object)doc.getDesc());
            apiTemplate.binding(TemplateVariable.NAME.getVariable(), (Object)doc.getName());
            apiTemplate.binding(TemplateVariable.LIST.getVariable(), doc.getList());
            HashMap<String, Object> templateVariables = new HashMap<String, Object>();
            templateVariables.put(TemplateVariable.TITLE.getVariable(), doc.getDesc());
            Template htmlApiDoc = HtmlApiDocBuilder.initTemplate(apiTemplate, "HtmlApiDoc.btl", templateVariables);
            FileUtil.nioWriteFile((String)htmlApiDoc.render(), (String)(config.getOutPath() + DocGlobalConstants.FILE_SEPARATOR + doc.getAlias() + ".html"));
        }
    }

    private static void buildErrorCodeDoc(List<ApiErrorCode> errorCodeList, String outPath) {
        if (CollectionUtil.isNotEmpty(errorCodeList)) {
            Template errorTemplate = BeetlTemplateUtil.getByName("ErrorCodeList.btl");
            errorTemplate.binding(TemplateVariable.LIST.getVariable(), errorCodeList);
            HashMap<String, Object> templateVariables = new HashMap<String, Object>();
            templateVariables.put(TemplateVariable.TITLE.getVariable(), "Error Code List");
            Template errorCodeDoc = HtmlApiDocBuilder.initTemplate(errorTemplate, "HtmlApiDoc.btl", templateVariables);
            FileUtil.nioWriteFile((String)errorCodeDoc.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "error_code.html"));
        }
    }

    private static void buildDictionary(List<ApiDocDict> apiDocDictList, String outPath) {
        if (CollectionUtil.isNotEmpty(apiDocDictList)) {
            Template template = BeetlTemplateUtil.getByName("Dictionary.btl");
            template.binding(TemplateVariable.DICT_LIST.getVariable(), apiDocDictList);
            HashMap<String, Object> templateVariables = new HashMap<String, Object>();
            templateVariables.put(TemplateVariable.TITLE.getVariable(), "Data Dictionaries");
            Template dictTpl = HtmlApiDocBuilder.initTemplate(template, "HtmlApiDoc.btl", templateVariables);
            FileUtil.nioWriteFile((String)dictTpl.render(), (String)(outPath + DocGlobalConstants.FILE_SEPARATOR + "dict.html"));
        }
    }

    private static Template initTemplate(Template template, String templateName, Map<String, Object> templateVariables) {
        String errorHtml = MarkDownUtil.toHtml(template.render());
        Template template1 = BeetlTemplateUtil.getByName(templateName);
        template1.binding(TemplateVariable.VERSION.getVariable(), (Object)now);
        template1.binding(TemplateVariable.HTML.getVariable(), (Object)errorHtml);
        template1.binding(TemplateVariable.CREATE_TIME.getVariable(), (Object)STR_TIME);
        template1.binding(templateVariables);
        return template1;
    }
}

