/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.template.RpcDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class RpcAdocBuilder {
    private static final String API_EXTENSION = "RpcApi.adoc";
    private static final String INDEX_DOC = "rpc-index.adoc";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        RpcAdocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setAdoc(true);
        config.setShowJavaType(true);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        RpcDocBuildTemplate docBuildTemplate = new RpcDocBuildTemplate();
        List<RpcApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "dubbo/DubboAllInOne.adoc", INDEX_DOC);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "dubbo/Dubbo.adoc", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.adoc", "ErrorCodeList.adoc");
        }
    }
}

