/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.doc.model.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiParamTreeUtil {
    public static List<ApiParam> apiParamToTree(List<ApiParam> apiParamList) {
        if (Objects.isNull(apiParamList)) {
            return null;
        }
        ArrayList<ApiParam> params = new ArrayList<ApiParam>();
        for (ApiParam apiParam : apiParamList) {
            apiParam.setField(apiParam.getField().replaceAll("\u2514\u2500", "").replaceAll("&nbsp;", ""));
            if (apiParam.getPid() != 0) continue;
            params.add(apiParam);
        }
        for (ApiParam apiParam : params) {
            apiParam.setChildren(ApiParamTreeUtil.getChild(apiParam.getId(), apiParamList));
        }
        return params;
    }

    private static List<ApiParam> getChild(int id, List<ApiParam> apiParamList) {
        ArrayList<ApiParam> childList = new ArrayList<ApiParam>();
        for (ApiParam param : apiParamList) {
            if (param.getPid() != id) continue;
            childList.add(param);
        }
        for (ApiParam param : childList) {
            param.setChildren(ApiParamTreeUtil.getChild(param.getId(), apiParamList));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }
}

