/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain;

import com.github.tobato.fastdfs.domain.ThumbImageConfig;
import org.apache.commons.lang3.Validate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="fdfs.thumbImage")
public class DefaultThumbImageConfig
implements ThumbImageConfig {
    private int width;
    private int height;
    private static String cachedPrefixName;

    @Override
    public String getPrefixName() {
        if (cachedPrefixName == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("_").append(this.width).append("x").append(this.height);
            cachedPrefixName = new String(buffer);
        }
        return cachedPrefixName;
    }

    @Override
    public String getThumbImagePath(String masterFilename) {
        Validate.notBlank((CharSequence)masterFilename, (String)"\u4e3b\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder buff = new StringBuilder(masterFilename);
        int index = buff.lastIndexOf(".");
        buff.insert(index, this.getPrefixName());
        return buff.toString();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

