/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.NetworkAddressRange;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;

public class NetworkAddressRules {
    private final Set<NetworkAddressRange> allowed;
    private final Set<NetworkAddressRange> denied;
    public static NetworkAddressRules ALLOW_ALL = new NetworkAddressRules((Set<NetworkAddressRange>)ImmutableSet.of((Object)NetworkAddressRange.ALL), Collections.emptySet());

    public static Builder builder() {
        return new Builder();
    }

    public NetworkAddressRules(Set<NetworkAddressRange> allowed, Set<NetworkAddressRange> denied) {
        this.allowed = allowed;
        this.denied = denied;
    }

    public boolean isAllowed(String testValue) {
        return this.allowed.stream().anyMatch(rule -> rule.isIncluded(testValue)) && this.denied.stream().noneMatch(rule -> rule.isIncluded(testValue));
    }

    public static class Builder {
        private final ImmutableSet.Builder<NetworkAddressRange> allowed = ImmutableSet.builder();
        private final ImmutableSet.Builder<NetworkAddressRange> denied = ImmutableSet.builder();

        public Builder allow(String expression) {
            this.allowed.add((Object)NetworkAddressRange.of(expression));
            return this;
        }

        public Builder deny(String expression) {
            this.denied.add((Object)NetworkAddressRange.of(expression));
            return this;
        }

        public NetworkAddressRules build() {
            ImmutableSet allowedRanges = this.allowed.build();
            if (allowedRanges.isEmpty()) {
                allowedRanges = ImmutableSet.of((Object)NetworkAddressRange.ALL);
            }
            return new NetworkAddressRules((Set<NetworkAddressRange>)allowedRanges, (Set<NetworkAddressRange>)this.denied.build());
        }
    }
}

