/*
 * Decompiled with CFR 0.152.
 */
package com.github.vector4wang;

import com.github.vector4wang.downloader.AbstractDownloader;
import com.github.vector4wang.downloader.JsoupDownloader;
import com.github.vector4wang.proxy.AbstractProxyExtractor;
import com.github.vector4wang.proxy.Proxy2;
import com.github.vector4wang.proxy.RandomProxy;
import com.github.vector4wang.service.CrawlerService;
import com.github.vector4wang.thread.CrawlerThread;
import com.github.vector4wang.util.CrawlerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VWCrawler {
    private static Logger logger = LoggerFactory.getLogger(CrawlerThread.class);
    private String url;
    private int timeout = 2000;
    private int retryCount = 2;
    private volatile LinkedBlockingQueue<String> waitCrawlerUrls = new LinkedBlockingQueue();
    private AbstractDownloader downloader = new JsoupDownloader();
    private volatile Set<String> crawledUrls = new HashSet<String>();
    private volatile Set<String> targetUrlRex = new HashSet<String>();
    private volatile Set<String> seedsPageUrlRex = new HashSet<String>();
    private volatile AbstractProxyExtractor proxyExtractor = new RandomProxy();
    private volatile Map<String, String> cookieMap;
    private volatile Map<String, String> headerMap;
    private CrawlerService crawlerService;
    private int threadCount = 1;
    private ExecutorService crawler = Executors.newCachedThreadPool();
    private List<CrawlerThread> crawlerThreads = new CopyOnWriteArrayList<CrawlerThread>();

    public String getUrl() {
        return this.url;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public LinkedBlockingQueue<String> getWaitCrawlerUrls() {
        return this.waitCrawlerUrls;
    }

    public Set<String> getCrawledUrls() {
        return this.crawledUrls;
    }

    public Set<String> getTargetUrlRex() {
        return this.targetUrlRex;
    }

    public Set<String> getSeedsPageUrlRex() {
        return this.seedsPageUrlRex;
    }

    public CrawlerService getCrawlerService() {
        return this.crawlerService;
    }

    public AbstractProxyExtractor getProxyExtractor() {
        return this.proxyExtractor;
    }

    public void setProxyExtractor(AbstractProxyExtractor proxyExtractor) {
        this.proxyExtractor = proxyExtractor;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public AbstractDownloader getDownloader() {
        return this.downloader;
    }

    public void start() {
        if (this.waitCrawlerUrls.isEmpty()) {
            throw new RuntimeException("\u5f85\u6293\u53d6URL\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u8bbe\u7f6ewaitCrawlerUrls(\u722c\u866b\u8d77\u59cbURL)");
        }
        for (int i = 0; i < this.threadCount; ++i) {
            this.crawlerThreads.add(new CrawlerThread(this));
        }
        for (CrawlerThread crawlerThread : this.crawlerThreads) {
            this.crawler.execute(crawlerThread);
        }
        this.crawler.shutdown();
    }

    public void tryStop() {
        boolean isStop;
        boolean isRunning = false;
        for (CrawlerThread crawlerThread : this.crawlerThreads) {
            if (!crawlerThread.isRunning()) continue;
            isRunning = true;
            break;
        }
        boolean bl = isStop = this.waitCrawlerUrls.isEmpty() && !isRunning;
        if (isStop) {
            logger.info("vw-crawler is finished and will stop!");
            this.stop();
        }
    }

    public boolean isTargetUrl(String url) {
        if (this.targetUrlRex.isEmpty()) {
            return true;
        }
        for (String s : this.targetUrlRex) {
            if (!CrawlerUtil.isMatch(s, url)) continue;
            return true;
        }
        return false;
    }

    public String generateUrl() throws InterruptedException {
        String url = this.getWaitCrawlerUrls().take();
        this.getCrawledUrls().add(url);
        return url;
    }

    public void addWaitCrawlerUrl(String href) {
        if (this.getCrawledUrls().contains(href)) {
            return;
        }
        if (this.getWaitCrawlerUrls().contains(href)) {
            return;
        }
        try {
            this.getWaitCrawlerUrls().put(href);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.crawler.shutdownNow();
        logger.info("vw-crawler pool closed!");
    }

    public static class Builder {
        private VWCrawler crawler = new VWCrawler();

        public Builder setUrl(String url) {
            this.crawler.waitCrawlerUrls.add(url);
            return this;
        }

        public Builder setTimeOut(int timeOut) {
            this.crawler.timeout = timeOut;
            return this;
        }

        public Builder setSeedUrl(String ... targetUrl) {
            if (targetUrl != null && targetUrl.length > 0) {
                for (String url : targetUrl) {
                    if (!StringUtils.isNotEmpty((CharSequence)url)) continue;
                    this.crawler.addWaitCrawlerUrl(url);
                }
            }
            return this;
        }

        public Builder setThreadCount(int count) {
            if (count <= 0) {
                throw new RuntimeException("\u7ebf\u7a0b\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            this.crawler.threadCount = count;
            return this;
        }

        public Builder setSeedsPage(String ... seedsPage) {
            if (seedsPage != null && seedsPage.length > 0) {
                for (String rex : seedsPage) {
                    this.crawler.seedsPageUrlRex.add(rex);
                }
            }
            return this;
        }

        public Builder setTargetUrlRex(String ... targetUrlRex) {
            if (targetUrlRex != null && targetUrlRex.length > 0) {
                for (String urlRex : targetUrlRex) {
                    this.crawler.targetUrlRex.add(urlRex);
                }
            }
            return this;
        }

        public Builder setSeedsPageUrlRex(String ... seedsPageUrlRex) {
            if (seedsPageUrlRex != null && seedsPageUrlRex.length > 0) {
                for (String seedsRex : seedsPageUrlRex) {
                    this.crawler.seedsPageUrlRex.add(seedsRex);
                }
            }
            return this;
        }

        public Builder setPageParser(CrawlerService crawlerService) {
            this.crawler.crawlerService = crawlerService;
            return this;
        }

        public Builder setDownloader(AbstractDownloader downloader) {
            this.crawler.downloader = downloader;
            return this;
        }

        public Builder setHeaders(HashMap<String, String> headerMap) {
            this.getHeader().putAll(headerMap);
            return this;
        }

        public Builder setHeader(String key, String value) {
            this.getHeader().put(key, value);
            return this;
        }

        public Builder setProxys(List<Proxy2> proxys) {
            if (proxys != null && proxys.size() > 0) {
                this.crawler.proxyExtractor.setProxy2s(proxys);
            }
            return this;
        }

        public Builder setAbsProxyExtracter(AbstractProxyExtractor extracter) {
            if (extracter != null) {
                if (!this.crawler.proxyExtractor.getProxy2s().isEmpty()) {
                    extracter.setProxy2s(this.crawler.proxyExtractor.getProxy2s());
                }
                this.crawler.proxyExtractor = extracter;
            }
            return this;
        }

        private Map<String, String> getHeader() {
            if (this.crawler.headerMap == null) {
                this.crawler.headerMap = new HashMap();
            }
            return this.crawler.headerMap;
        }

        public Builder setRetryCount(int retryCount) {
            this.crawler.retryCount = retryCount;
            return this;
        }

        public VWCrawler build() {
            return this.crawler;
        }
    }
}

