/*
 * Decompiled with CFR 0.152.
 */
package com.github.vector4wang.util;

import com.github.vector4wang.annotation.CssSelector;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReflectUtils {
    public static Object parseValueWithType(String value, Field field) {
        Class<?> type = field.getType();
        Object result = null;
        try {
            if (Boolean.TYPE == type) {
                result = Boolean.parseBoolean(value);
            } else if (Byte.TYPE == type) {
                result = Byte.parseByte(value);
            } else if (Short.TYPE == type) {
                result = Short.parseShort(value);
            } else if (Integer.TYPE == type) {
                result = Integer.parseInt(value);
            } else if (Long.TYPE == type) {
                result = Long.parseLong(value);
            } else if (Float.TYPE == type) {
                result = Float.valueOf(Float.parseFloat(value));
            } else if (Double.TYPE == type) {
                result = Double.parseDouble(value);
            } else {
                if (Date.class.equals(type)) {
                    CssSelector annotation = field.getAnnotation(CssSelector.class);
                    String dateFormat = annotation.dateFormat();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                    return simpleDateFormat.parse(value);
                }
                result = value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

