/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.virtualcry.sapjco.spring.beans.factory;

import cn.gitlab.virtualcry.sapjco.beans.factory.JCoBeanFactory;
import cn.gitlab.virtualcry.sapjco.beans.factory.JCoBeanFactoryProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SpringExtensionJCoBeanFactory
implements JCoBeanFactory,
InitializingBean {
    private final ApplicationContext ctx;

    public SpringExtensionJCoBeanFactory(ApplicationContext ctx) {
        Assert.notNull((Object)ctx, (String)"ApplicationContext could not be null.");
        this.ctx = ctx;
    }

    public void afterPropertiesSet() {
        JCoBeanFactoryProvider.getSingleton().register((Object)this);
    }

    public <T> void register(String beanName, T bean) {
        ((DefaultListableBeanFactory)this.ctx.getAutowireCapableBeanFactory()).registerSingleton(beanName, bean);
    }

    public boolean containsBean(String beanName) {
        return this.ctx.containsBean(beanName);
    }

    public Object getBean(String beanName) {
        return this.ctx.getBean(beanName);
    }

    public <T> T getBean(String beanName, Class<T> beanType) {
        return (T)this.ctx.getBean(beanName, beanType);
    }

    public <T> T getBean(Class<T> beanType) {
        return (T)this.ctx.getBean(beanType);
    }

    public <T> List<T> getBeans(Class<T> beanType) {
        return Arrays.stream(this.getBeanNamesForType(beanType)).map(beanName -> this.getBean((String)beanName, beanType)).collect(Collectors.toList());
    }

    public <T> Map<String, T> getBeansOfType(Class<T> beanType) {
        return this.ctx.getBeansOfType(beanType);
    }

    public String[] getBeanNamesForType(Class beanType) {
        return this.ctx.getBeanNamesForType(beanType);
    }

    public void unRegister(String beanName) {
        ((DefaultListableBeanFactory)this.ctx.getAutowireCapableBeanFactory()).removeBeanDefinition(beanName);
    }
}

