/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.virtualcry.sapjco.spring.beans.factory.annotation;

import cn.gitlab.virtualcry.sapjco.spring.beans.factory.annotation.JCoAnnotationBeanNameGenerator;
import cn.gitlab.virtualcry.sapjco.spring.context.annotation.JCoClassPathBeanDefinitionScanner;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JCoComponentScanAnnotationParser {
    private static final Logger log = LoggerFactory.getLogger(JCoComponentScanAnnotationParser.class);
    private Environment environment;
    private ResourceLoader resourceLoader;
    private final BeanNameGenerator beanNameGenerator;
    private final BeanDefinitionRegistry registry;

    public JCoComponentScanAnnotationParser(Environment environment, ResourceLoader resourceLoader, BeanDefinitionRegistry registry) {
        this.resourceLoader = resourceLoader;
        this.environment = environment;
        this.beanNameGenerator = this.resolveBeanNameGenerator(registry);
        this.registry = registry;
    }

    public Set<BeanDefinitionHolder> parse(Set<String> packagesToScan) {
        Set<String> resolvedPackagesToScan = this.resolvePackagesToScan(packagesToScan);
        if (CollectionUtils.isEmpty(resolvedPackagesToScan)) {
            return new LinkedHashSet<BeanDefinitionHolder>(0);
        }
        return this.registerJCoBeans(resolvedPackagesToScan, this.registry);
    }

    private Set<BeanDefinitionHolder> registerJCoBeans(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        JCoClassPathBeanDefinitionScanner scanner = new JCoClassPathBeanDefinitionScanner(registry, this.environment, this.resourceLoader);
        scanner.setBeanNameGenerator(this.beanNameGenerator);
        return packagesToScan.stream().map(xva$0 -> scanner.doScan((String)xva$0)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private BeanNameGenerator resolveBeanNameGenerator(BeanDefinitionRegistry registry) {
        Object beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)registry;
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            if (log.isDebugEnabled()) {
                log.debug("BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
                log.debug("BeanNameGenerator will be a instance of " + JCoAnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation.");
            }
            beanNameGenerator = new JCoAnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }

    private Set<String> resolvePackagesToScan(Set<String> packagesToScan) {
        return packagesToScan.stream().filter(StringUtils::hasText).map(packageToScan -> this.environment.resolvePlaceholders(packageToScan.trim())).collect(Collectors.toSet());
    }
}

