/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.virtualcry.sapjco.spring.context;

import cn.gitlab.virtualcry.sapjco.config.JCoDataProvider;
import cn.gitlab.virtualcry.sapjco.server.listener.DefaultJCoErrorListener;
import cn.gitlab.virtualcry.sapjco.server.listener.DefaultJCoExceptionListener;
import cn.gitlab.virtualcry.sapjco.server.listener.DefaultJCoStateChangedListener;
import cn.gitlab.virtualcry.sapjco.spring.beans.factory.SpringExtensionJCoBeanFactory;
import cn.gitlab.virtualcry.sapjco.spring.beans.factory.SpringExtensionJCoConnectionFactory;
import cn.gitlab.virtualcry.sapjco.spring.beans.factory.annotation.JCoAnnotationBeanPostProcessor;
import cn.gitlab.virtualcry.sapjco.spring.util.BeanRegistrar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.PriorityOrdered;

public class JCoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(JCoApplicationContextInitializer.class);
    public static final String JCO_BEAN_FACTORY_BEAN_NAME = "cn.gitlab.virtualcry.sapjco.spring.beans.factory.annotation.internalSpringExtensionJCoBeanFactory";
    public static final String JCO_CONNECTION_FACTORY_BEAN_NAME = "cn.gitlab.virtualcry.sapjco.spring.beans.factory.annotation.internalSpringExtensionJCoConnectionFactory";
    public static final String JCO_ANNOTATION_PROCESSOR_BEAN_NAME = "cn.gitlab.virtualcry.sapjco.spring.beans.factory.annotation.internalJCoAnnotationBeanPostProcessor";
    public static final String ERROR_LISTENER_BEAN_NAME = "cn.gitlab.virtualcry.sapjco.server.listener.internalDefaultJCoErrorListener";
    public static final String EXCEPTION_LISTENER_BEAN_NAME = "cn.gitlab.virtualcry.sapjco.server.listener.internalDefaultJCoExceptionListener";
    public static final String STATE_CHANGED_LISTENER_BEAN_NAME = "cn.gitlab.virtualcry.sapjco.server.listener.internalDefaultJCoStateChangedListener";
    private static final AtomicBoolean isInit = new AtomicBoolean(false);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (!isInit.compareAndSet(false, true)) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Initializing SAP Java Connector");
        }
        JCoDataProvider.registerInEnvironment();
        applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new JCoComponentScanRegistrar());
    }

    public static class JCoComponentScanRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    PriorityOrdered {
        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            BeanRegistrar.registerInfrastructureBean(registry, JCoApplicationContextInitializer.JCO_ANNOTATION_PROCESSOR_BEAN_NAME, JCoAnnotationBeanPostProcessor.class);
            this.registerDefaultJCoFactories(registry);
            this.registerDefaultJCoListeners(registry);
        }

        private void registerDefaultJCoFactories(BeanDefinitionRegistry registry) {
            BeanRegistrar.registerInfrastructureBean(registry, JCoApplicationContextInitializer.JCO_BEAN_FACTORY_BEAN_NAME, SpringExtensionJCoBeanFactory.class);
            BeanRegistrar.registerInfrastructureBean(registry, JCoApplicationContextInitializer.JCO_CONNECTION_FACTORY_BEAN_NAME, SpringExtensionJCoConnectionFactory.class);
        }

        private void registerDefaultJCoListeners(BeanDefinitionRegistry registry) {
            BeanRegistrar.registerInfrastructureBean(registry, JCoApplicationContextInitializer.ERROR_LISTENER_BEAN_NAME, DefaultJCoErrorListener.class);
            BeanRegistrar.registerInfrastructureBean(registry, JCoApplicationContextInitializer.EXCEPTION_LISTENER_BEAN_NAME, DefaultJCoExceptionListener.class);
            BeanRegistrar.registerInfrastructureBean(registry, JCoApplicationContextInitializer.STATE_CHANGED_LISTENER_BEAN_NAME, DefaultJCoStateChangedListener.class);
        }
    }
}

