/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.virtualcry.sapjco.spring.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class AnnotationUtils
extends AnnotatedElementUtils {
    public static Set<AnnotationAttributes> attributesForRepeatable(AnnotationMetadata metadata, Class<?> containerClass, Class<?> annotationClass) {
        return AnnotationUtils.attributesForRepeatable(metadata, containerClass.getName(), annotationClass.getName());
    }

    private static Set<AnnotationAttributes> attributesForRepeatable(AnnotationMetadata metadata, String containerClassName, String annotationClassName) {
        LinkedHashSet<AnnotationAttributes> result = new LinkedHashSet<AnnotationAttributes>();
        MultiValueMap tmp = metadata.getAllAnnotationAttributes(annotationClassName, false);
        AnnotationUtils.addAttributesIfNotNull(result, metadata.getAnnotationAttributes(annotationClassName, false));
        Map container = metadata.getAnnotationAttributes(containerClassName, false);
        if (container != null && container.containsKey("value")) {
            for (Map containedAttributes : (Map[])container.get("value")) {
                AnnotationUtils.addAttributesIfNotNull(result, containedAttributes);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static void addAttributesIfNotNull(Set<AnnotationAttributes> result, Map<String, Object> attributes) {
        if (attributes != null) {
            result.add(AnnotationAttributes.fromMap(attributes));
        }
    }
}

