/*
 * Decompiled with CFR 0.152.
 */
package org.wf.jwtp.configuration.client;

import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.wf.jwtp.client.ClientInterceptor;
import org.wf.jwtp.configuration.JwtPermissionProperties;
import org.wf.jwtp.perm.RestUrlPerm;
import org.wf.jwtp.perm.SimpleUrlPerm;
import org.wf.jwtp.perm.UrlPerm;

@EnableConfigurationProperties(value={JwtPermissionProperties.class})
public class JwtPermissionClientConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private JwtPermissionProperties properties;

    @ConditionalOnProperty(name={"jwtp.url-perm-type"}, havingValue="0")
    @Bean
    public UrlPerm simpleUrlPerm() {
        return new SimpleUrlPerm();
    }

    @ConditionalOnProperty(name={"jwtp.url-perm-type"}, havingValue="1")
    @Bean
    public UrlPerm restUrlPerm() {
        return new RestUrlPerm();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        UrlPerm urlPerm = this.getBean(UrlPerm.class);
        String[] path = this.properties.getPath();
        String[] excludePath = this.properties.getExcludePath();
        ClientInterceptor interceptor = new ClientInterceptor(this.properties.getAuthCenterUrl(), urlPerm);
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(path).excludePathPatterns(excludePath);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private <T> T getBean(Class<T> clazz) {
        T bean = null;
        Collection beans = this.applicationContext.getBeansOfType(clazz).values();
        while (beans.iterator().hasNext() && (bean = (T)beans.iterator().next()) == null) {
        }
        return bean;
    }
}

