/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core.filter;

import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import java.io.IOException;
import java.util.Base64;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Knife4jSecurityBasicAuthFilter
implements Filter {
    Logger logger = LoggerFactory.getLogger(Knife4jSecurityBasicAuthFilter.class);
    public static final String SwaggerBootstrapUiBasicAuthSession = "Knife4jAggregationBasicAuthSession";
    private BasicAuth basicAuth;

    protected String decodeBase64(String source) {
        String decodeStr = null;
        if (source != null) {
            try {
                byte[] bytes = Base64.getDecoder().decode(source);
                decodeStr = new String(bytes);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return decodeStr;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.basicAuth != null && this.basicAuth.isEnable()) {
            Object swaggerSessionValue = servletRequest.getSession().getAttribute(SwaggerBootstrapUiBasicAuthSession);
            if (swaggerSessionValue != null) {
                chain.doFilter(request, response);
                return;
            }
            String auth = servletRequest.getHeader("Authorization");
            if (auth == null || "".equals(auth)) {
                this.writeForbiddenCode(httpServletResponse);
                return;
            }
            String userAndPass = this.decodeBase64(auth.substring(6));
            String[] upArr = userAndPass.split(":");
            if (upArr.length != 2) {
                this.writeForbiddenCode(httpServletResponse);
                return;
            }
            String iptUser = upArr[0];
            String iptPass = upArr[1];
            if (iptUser.equals(this.basicAuth.getUsername()) && iptPass.equals(this.basicAuth.getPassword())) {
                servletRequest.getSession().setAttribute(SwaggerBootstrapUiBasicAuthSession, (Object)this.basicAuth.getUsername());
                chain.doFilter(request, response);
                return;
            }
            this.writeForbiddenCode(httpServletResponse);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private void writeForbiddenCode(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"input OpenAPI userName & password \"");
        httpServletResponse.getWriter().write("You do not have permission to access this resource");
    }

    public Knife4jSecurityBasicAuthFilter(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }
}

