/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.enums.OpenApiVersion;
import com.github.xiaoymin.knife4j.spring.gateway.spec.AbstractOpenAPIResource;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v2.OpenAPI2Resource;
import com.github.xiaoymin.knife4j.spring.gateway.utils.PathUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ServiceDiscoverHandler
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoverHandler.class);
    final Knife4jGatewayProperties gatewayProperties;
    private List<OpenAPI2Resource> gatewayResources;
    private Environment environment;

    public ServiceDiscoverHandler(Knife4jGatewayProperties gatewayProperties) {
        this.gatewayProperties = gatewayProperties;
    }

    public void discover(List<String> service) {
        log.debug("service has change.");
        Set<String> excludeService = this.getExcludeService();
        OpenApiVersion apiVersion = this.gatewayProperties.getDiscover().getVersion();
        String url = this.gatewayProperties.getDiscover().getUrl();
        Map<String, Knife4jGatewayProperties.ServiceConfigInfo> configInfoMap = this.gatewayProperties.getDiscover().getServiceConfig();
        ArrayList<OpenAPI2Resource> resources = new ArrayList<OpenAPI2Resource>();
        if (service != null && !service.isEmpty()) {
            for (String serviceName : service) {
                if (excludeService.contains(serviceName)) continue;
                int order = 0;
                String groupName = serviceName;
                String contextPath = "/";
                Knife4jGatewayProperties.ServiceConfigInfo serviceConfigInfo = configInfoMap.get(serviceName);
                if (serviceConfigInfo != null) {
                    order = serviceConfigInfo.getOrder();
                    groupName = serviceConfigInfo.getGroupName();
                    contextPath = PathUtils.append(contextPath, serviceConfigInfo.getContextPath());
                }
                OpenAPI2Resource resource = new OpenAPI2Resource(order, true);
                resource.setName(groupName);
                resource.setContextPath(contextPath);
                if (apiVersion == OpenApiVersion.OpenAPI3 && contextPath.equalsIgnoreCase("/")) {
                    resource.setContextPath("/" + serviceName);
                }
                resource.setUrl(PathUtils.append(serviceName, url));
                resource.setId(Base64.getEncoder().encodeToString((resource.getName() + resource.getUrl() + resource.getContextPath()).getBytes(StandardCharsets.UTF_8)));
                resources.add(resource);
            }
        }
        if (this.gatewayProperties.getRoutes() != null) {
            for (Knife4jGatewayProperties.Router router : this.gatewayProperties.getRoutes()) {
                OpenAPI2Resource resource = new OpenAPI2Resource(router.getOrder(), false);
                resource.setName(router.getName());
                resource.setUrl(router.getUrl());
                resource.setContextPath(router.getContextPath());
                resource.setId(Base64.getEncoder().encodeToString((resource.getName() + resource.getUrl() + resource.getContextPath()).getBytes(StandardCharsets.UTF_8)));
                resources.add(resource);
            }
        }
        this.gatewayResources = resources;
    }

    public List<OpenAPI2Resource> getResources(String forwardPath) {
        List<OpenAPI2Resource> resources = this.getGatewayResources();
        if (resources != null && !resources.isEmpty()) {
            Collections.sort(resources, Comparator.comparing(AbstractOpenAPIResource::getOrder));
            for (OpenAPI2Resource resource : resources) {
                resource.setContextPath(PathUtils.append(forwardPath, resource.getContextPath()));
                resource.setUrl(PathUtils.append(forwardPath, resource.getUrl()));
            }
            return resources;
        }
        return Collections.EMPTY_LIST;
    }

    public Set<String> getExcludeService() {
        Set<String> configServices;
        HashSet<String> excludeService = new HashSet<String>();
        String gatewayService = this.environment.getProperty("spring.application.name");
        if (StringUtils.hasLength((String)gatewayService)) {
            excludeService.add(gatewayService);
        }
        if ((configServices = this.gatewayProperties.getDiscover().getExcludedServices()) != null && !configServices.isEmpty()) {
            excludeService.addAll(configServices);
        }
        return excludeService;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public List<OpenAPI2Resource> getGatewayResources() {
        return this.gatewayResources;
    }
}

