/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.endpoint;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceDiscoverHandler;
import com.github.xiaoymin.knife4j.spring.gateway.enums.GatewayStrategy;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v3.OpenAPI3Response;
import com.github.xiaoymin.knife4j.spring.gateway.utils.PathUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@ConditionalOnProperty(name={"knife4j.gateway.enabled"}, havingValue="true")
public class OpenAPIEndpoint {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIEndpoint.class);
    final Knife4jGatewayProperties knife4jGatewayProperties;
    final ApplicationContext applicationContext;

    @GetMapping(value={"/v3/api-docs/swagger-config"})
    public Mono<ResponseEntity<OpenAPI3Response>> swaggerConfig(ServerHttpRequest request) {
        OpenAPI3Response response = new OpenAPI3Response();
        String contextPath = request.getPath().contextPath().value();
        if (!StringUtils.hasLength((String)contextPath)) {
            List referer = request.getHeaders().get((Object)"Referer");
            if (referer != null && !referer.isEmpty()) {
                String value = (String)referer.get(0);
                log.debug("Referer:{}", (Object)value);
                contextPath = PathUtils.getContextPath(value);
            } else {
                contextPath = "/";
            }
        }
        String basePath = contextPath;
        response.setConfigUrl("/v3/api-docs/swagger-config");
        response.setOauth2RedirectUrl(this.knife4jGatewayProperties.getDiscover().getOas3().getOauth2RedirectUrl());
        response.setValidatorUrl(this.knife4jGatewayProperties.getDiscover().getOas3().getValidatorUrl());
        log.debug("forward-path:{}", (Object)basePath);
        if (this.knife4jGatewayProperties.getStrategy() == GatewayStrategy.MANUAL) {
            log.debug("manual strategy.");
            LinkedList<Knife4jGatewayProperties.Router> sortedSet = new LinkedList<Knife4jGatewayProperties.Router>();
            List<Knife4jGatewayProperties.Router> routers = this.knife4jGatewayProperties.getRoutes();
            if (routers != null && !routers.isEmpty()) {
                Collections.sort(routers, Comparator.comparing(Knife4jGatewayProperties.Router::getOrder));
                for (Knife4jGatewayProperties.Router router : routers) {
                    router.setUrl(PathUtils.append(basePath, router.getUrl()));
                    router.setContextPath(PathUtils.append(basePath, router.getContextPath()));
                    sortedSet.add(router);
                }
                response.setUrls(sortedSet);
            }
        } else {
            log.debug("discover strategy.");
            ServiceDiscoverHandler serviceDiscoverHandler = (ServiceDiscoverHandler)this.applicationContext.getBean(ServiceDiscoverHandler.class);
            if (serviceDiscoverHandler != null) {
                response.setUrls(serviceDiscoverHandler.getResources(basePath));
            }
        }
        return Mono.just((Object)ResponseEntity.ok().body((Object)response));
    }

    public OpenAPIEndpoint(Knife4jGatewayProperties knife4jGatewayProperties, ApplicationContext applicationContext) {
        this.knife4jGatewayProperties = knife4jGatewayProperties;
        this.applicationContext = applicationContext;
    }
}

