/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.utils;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PathUtils {
    private static final Logger log = LoggerFactory.getLogger(PathUtils.class);
    static final String DOC_URL = "/doc.html";
    static final Pattern PATTERN = Pattern.compile("(.*?)\\/doc\\.html", 2);

    public static String getContextPath(String referer) {
        if (StringUtils.hasLength((String)referer)) {
            try {
                URI uri = URI.create(referer);
                String path = uri.getPath();
                Matcher mather = PATTERN.matcher(path);
                if (mather.find()) {
                    return mather.group(1);
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        return "/";
    }

    public static String append(String ... paths) {
        if (Objects.isNull(paths) || paths.length == 0) {
            return "/";
        }
        String fullPath = Arrays.stream(paths).filter(StringUtils::hasLength).map(path -> "/" + path).collect(Collectors.joining());
        return fullPath.replaceAll("/+", "/");
    }

    private PathUtils() {
    }
}

