/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.filter;

import com.github.xiaoymin.knife4j.extend.filter.BasicFilter;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProductionSecurityFilter
extends BasicFilter
implements Filter {
    private boolean production = false;
    private Integer customCode = 200;

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.setProduction(Boolean.valueOf(filterConfig.getInitParameter("production")));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.production) {
            String uri = httpServletRequest.getRequestURI();
            if (!this.match(uri)) {
                chain.doFilter(request, response);
            } else {
                HttpServletResponse resp = (HttpServletResponse)response;
                resp.setStatus(this.customCode.intValue());
                resp.sendError(this.customCode.intValue(), "You do not have permission to access this page");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public ProductionSecurityFilter(boolean production) {
        this.production = production;
    }

    public ProductionSecurityFilter(boolean production, Integer customCode) {
        this.production = production;
        this.customCode = customCode;
    }

    public ProductionSecurityFilter() {
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }
}

