/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.serialize.CKJSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class CkArray {
    public static String[] string2Array(String str) {
        if (str.indexOf("[") == 0 && str.indexOf("]") == str.length() - 1) {
            return str.substring(1, str.length() - 1).split(",");
        }
        return str.split(",");
    }

    public static String array2String(String[] arr) {
        return Arrays.toString(arr);
    }

    public static <T> T[] string2Array(Class<T> clazz, String str) {
        List<T> ts = CKJSON.getInstance().parseArray(str, clazz);
        return ts.toArray();
    }

    public static String array2String(Object[] arr) {
        return CKJSON.getInstance().toJsonString(arr);
    }

    public static <T> List<List<T>> splitListByChunk(List<T> list, int chunkSize) {
        int size = list.size();
        return IntStream.range(0, (size + chunkSize - 1) / chunkSize).mapToObj(i -> list.subList(i * chunkSize, Math.min((i + 1) * chunkSize, size))).collect(Collectors.toList());
    }

    public static <T> List<List<T>> splitListByParts(List<T> sourceList, int numberOfParts) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int listSize = sourceList.size();
        int chunkSize = (int)Math.ceil((double)listSize / (double)numberOfParts);
        for (int i = 0; i < listSize; i += chunkSize) {
            int end = Math.min(listSize, i + chunkSize);
            result.add(sourceList.subList(i, end));
        }
        return result;
    }
}

