/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import java.nio.charset.Charset;

public enum CkContentType {
    MULTIPART_FORM_DATA("multipart/form-data", "multipart/form-data"),
    WWW_FORM_URL_ENCODED("application/x-www-form-urlencoded", "application/x-www-form-urlencoded"),
    XLS("xls", "application/vnd.ms-excel"),
    GZ("gzip", "application/gzip"),
    JAR("jar", "application/java-archive"),
    XLSX("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    DOC("doc", "application/msword"),
    DOCX("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    BIN("bin", "application/octet-stream"),
    EXE("exe", "application/octet-stream"),
    PPT("ppt", "application/vnd.ms-powerpoint"),
    PPTX("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation"),
    JS("js", "application/x-javascript"),
    RAR("rar", "application/vnd.rar"),
    DWG("dwg", "application/x-dwg"),
    ZIP("zip", "application/zip"),
    MP3("mp3", "audio/mpeg"),
    GIF("gif", "image/gif"),
    JPEG("jpeg", "image/jpeg "),
    JPG("jpg", "image/jpg"),
    PNG("png", "image/png"),
    TXT("txt", "text/plain"),
    JSON("json", "application/json"),
    GENERIC("*", "application/octet-stream"),
    ZERO_ZERO_ONE("001", "application/x-001"),
    THREE_TWO_THREE("323", "text/h323"),
    NINE_ZERO_SEVEN("907", "drawing/907"),
    ACP("acp", "audio/x-mei-aac"),
    AAC("aac", "audio/aac"),
    AIF("aif", "audio/aiff"),
    AIFF("aiff", "audio/aiff"),
    ASA("asa", "text/asa"),
    ASP("asp", "text/asp"),
    AU("au", "audio/basic"),
    AWF("awf", "application/vnd.adobe.workflow"),
    BMP("bmp", "application/x-bmp"),
    C4T("c4t", "application/x-c4t"),
    CAL("cal", "application/x-cals"),
    CDF("cdf", "application/x-netcdf"),
    CEL("cel", "application/x-cel"),
    CG4("cg4", "application/x-g4"),
    CIT("cit", "application/x-cit"),
    CML("cml", "text/xml"),
    CMX("cmx", "application/x-cmx"),
    CRL("crl", "application/pkix-crl"),
    CSI("csi", "application/x-csi"),
    CUT("cut", "application/x-cut"),
    DBM("dbm", "application/x-dbm"),
    DCD("dcd", "text/xml"),
    DER("der", "application/x-x509-ca-cert"),
    DIB("dib", "application/x-dib"),
    DRW("drw", "application/x-drw"),
    DWF("dwf", "Model/vnd.dwf"),
    DXF("dxf", "application/x-dxf"),
    EMF("emf", "application/x-emf"),
    ENT("ent", "text/xml"),
    EPS("eps", "application/x-ps"),
    ETD("etd", "application/x-ebx"),
    FAX("fax", "image/fax"),
    FIF("fif", "application/fractals"),
    FRM("frm", "application/x-frm"),
    GBR("gbr", "application/x-gbr"),
    GP4("gp4", "application/x-gp4"),
    HMR("hmr", "application/x-hmr"),
    HPL("hpl", "application/x-hpl"),
    HRF("hrf", "application/x-hrf"),
    HTC("htc", "text/x-component"),
    HTML("html", "text/html"),
    HTX("htx", "text/html"),
    ICO("ico", "image/x-icon"),
    IFF("iff", "application/x-iff"),
    IGS("igs", "application/x-igs"),
    IMG("img", "application/x-img"),
    ISP("isp", "application/x-internet-signup"),
    JAVA("java", "java/*"),
    JPE("jpe", "image/jpeg"),
    JSP("jsp", "text/html"),
    LAR("lar", "application/x-laplayer-reg"),
    LAVS("lavs", "audio/x-liquid-secure"),
    LMSFf("lmsff", "audio/x-la-lms"),
    LTR("ltr", "application/x-ltr"),
    M2V("m2v", "video/x-mpeg"),
    M4E("m4e", "video/mpeg4"),
    MAN("man", "application/x-troff-man"),
    MDB("mdb", "application/msaccess"),
    MFP("mfp", "application/x-shockwave-flash"),
    MHTMl("mhtml", "message/rfc822"),
    MID("mid", "audio/mid"),
    MIL("mil", "application/x-mil"),
    MND("mnd", "audio/x-musicnet-download"),
    MOCHa("mocha", "application/x-javascript"),
    MP1("mp1", "audio/mp1"),
    MP2V("mp2v", "video/mpeg"),
    MP4("mp4", "video/mpeg4"),
    MPD("mpd", "application/vnd.ms-project"),
    MPEG("mpeg", "video/mpg"),
    MPGA("mpga", "audio/rn-mpeg"),
    MPS("mps", "video/x-mpeg"),
    MPV("mpv", "video/mpg"),
    MPW("mpw", "application/vnd.ms-project"),
    MTX("mtx", "text/xml"),
    NET("net", "image/pnetvue"),
    NWS("nws", "message/rfc822"),
    OUT("out", "application/x-out"),
    P12("p12", "application/x-pkcs12"),
    P7C("p7c", "application/pkcs7-mime"),
    P7R("p7r", "application/x-pkcs7-certreqresp"),
    PC5("pc5", "application/x-pc5"),
    PCL("pcl", "application/x-pcl"),
    PDF("pdf", "application/pdf"),
    PDX("pdx", "application/vnd.adobe.pdx"),
    PGL("pgl", "application/x-pgl"),
    PKO("pko", "application/vnd.ms-pki.pko"),
    PLG("plg", "text/html"),
    PLT("plt", "application/x-plt"),
    PPA("ppa", "application/vnd.ms-powerpoint"),
    PPS("pps", "application/vnd.ms-powerpoint"),
    PRF("prf", "application/pics-rules"),
    PRT("prt", "application/x-prt"),
    PS("ps", "application/postscript"),
    PWZ("pwz", "application/vnd.ms-powerpoint"),
    RA("ra", "audio/vnd.rn-realaudio"),
    RAS("ras", "application/x-ras"),
    RDF("rdf", "text/xml"),
    RED("red", "application/x-red"),
    RJS("rjs", "application/vnd.rn-realsystem-rjs"),
    RLC("rlc", "application/x-rlc"),
    RM("rm", "application/vnd.rn-realmedia"),
    RMI("rmi", "audio/mid"),
    RMM("rmm", "audio/x-pn-realaudio"),
    RMS("rms", "application/vnd.rn-realmedia-secure"),
    RMX("rmx", "application/vnd.rn-realsystem-rmx"),
    RP("rp", "image/vnd.rn-realpix"),
    RSML("rsml", "application/vnd.rn-rsml"),
    RTF("rtf", "application/msword"),
    RV("rv", "video/vnd.rn-realvideo"),
    SAT("sat", "application/x-sat"),
    SDW("sdw", "application/x-sdw"),
    SLB("slb", "application/x-slb"),
    SLK("slk", "drawing/x-slk"),
    SMIL("smil", "application/smil"),
    SND("snd", "audio/basic"),
    SOR("sor", "text/plain"),
    SPL("spl", "application/futuresplash"),
    SSM("ssm", "application/streamingmedia"),
    STL("stl", "application/vnd.ms-pki.stl"),
    STY("sty", "application/x-sty"),
    SWF("swf", "application/x-shockwave-flash"),
    TG4("tg4", "application/x-tg4"),
    TIF("tif", "image/tiff"),
    SH("sh", "application/x-sh"),
    TIFF("tiff", "image/tiff"),
    TOP("top", "drawing/x-top"),
    TSD("tsd", "text/xml"),
    UIN("uin", "application/x-icq"),
    VCF("vcf", "text/x-vcard"),
    VDX("vdx", "application/vnd.visio"),
    VPG("vpg", "application/x-vpeg005"),
    VSD("vsd", "application/x-vsd"),
    VST("vst", "application/vnd.visio"),
    VSW("vsw", "application/vnd.visio"),
    VTX("vtx", "application/vnd.visio"),
    WAV("wav", "audio/wav"),
    WB1("wb1", "application/x-wb1"),
    WB3("wb3", "application/x-wb3"),
    WIZ("wiz", "application/msword"),
    WK4("wk4", "application/x-wk4"),
    WKS("wks", "application/x-wks"),
    WMA("wma", "audio/x-ms-wma"),
    WMF("wmf", "application/x-wmf"),
    WMV("wmv", "video/x-ms-wmv"),
    WMZ("wmz", "application/x-ms-wmz"),
    WPD("wpd", "application/x-wpd"),
    WPL("wpl", "application/vnd.ms-wpl"),
    WR1("wr1", "application/x-wr1"),
    WRK("wrk", "application/x-wrk"),
    WS2("ws2", "application/x-ws"),
    WSDL("wsdl", "text/xml"),
    XDP("xdp", "application/vnd.adobe.xdp"),
    XFD("xfd", "application/vnd.adobe.xfd"),
    XHTMl("xhtml", "text/html"),
    XML("xml", "text/xml"),
    XQ("xq", "text/xml"),
    XQUERY("xquery", "text/xml"),
    XSL("xsl", "text/xml"),
    XWD("xwd", "application/x-xwd"),
    SIS("sis", "application/vnd.symbian.install"),
    X_T("x_t", "application/x-x_t"),
    APK("apk", "application/vnd.android.package-archive"),
    THREE_ZERO_ONE("301", "application/x-301"),
    NINE_ZERO_SIX("906", "application/x-906"),
    A11("a11", "application/x-a11"),
    AI("ai", "application/postscript"),
    AIFC("aifc", "audio/aiff"),
    ANV("anv", "application/x-anv"),
    ASF("asf", "video/x-ms-asf"),
    ASX("asx", "video/x-ms-asf"),
    AVI("avi", "video/avi"),
    BIZ("biz", "text/xml"),
    BOT("bot", "application/x-bot"),
    C90("c90", "application/x-c90"),
    CAT("cat", "application/vnd.ms-pki.seccat"),
    CDR("cdr", "application/x-cdr"),
    CER("cer", "application/x-x509-ca-cert"),
    CGM("cgm", "application/x-cgm"),
    CLAZz("class", "java/*"),
    CMP("cmp", "application/x-cmp"),
    COT("cot", "application/x-cot"),
    CRT("crt", "application/x-x509-ca-cert"),
    CSS("css", "text/css"),
    DBF("dbf", "application/x-dbf"),
    DBX("dbx", "application/x-dbx"),
    DCX("dcx", "application/x-dcx"),
    DGN("dgn", "application/x-dgn"),
    DLL("dll", "application/x-msdownload"),
    DOT("dot", "application/msword"),
    DTD("dtd", "text/xml"),
    DXB("dxb", "application/x-dxb"),
    EDN("edn", "application/vnd.adobe.edn"),
    EML("eml", "message/rfc822"),
    EPI("epi", "application/x-epi"),
    FDF("fdf", "application/vnd.fdf"),
    FO("fo", "text/xml"),
    G4("g4", "application/x-g4"),
    POINt(".", "application/x-"),
    GL2("gl2", "application/x-gl2"),
    HGL("hgl", "application/x-hgl"),
    HPG("hpg", "application/x-hpgl"),
    HQX("hqx", "application/mac-binhex40"),
    HTA("hta", "application/hta"),
    HTM("htm", "text/html"),
    HTT("htt", "text/webviewhtml"),
    ICB("icb", "application/x-icb"),
    IG4("ig4", "application/x-g4"),
    III("iii", "application/x-iphone"),
    INS("ins", "application/x-internet-signup"),
    IVF("IVF", "video/x-ivf"),
    JFIF("jfif", "image/jpeg"),
    LA1("la1", "audio/x-liquid-file"),
    LATEx("latex", "application/x-late"),
    LBM("lbm", "application/x-lbm"),
    LS("ls", "application/x-javascript"),
    M1V("m1v", "video/x-mpeg"),
    M3U("m3u", "audio/mpegurl"),
    MAC("mac", "application/x-mac"),
    MATH("math", "text/xml"),
    MHT("mht", "message/rfc822"),
    MI("mi", "application/x-mi"),
    MIDI("midi", "application/x-mi"),
    MML("mml", "audio/mid"),
    MNS("mns", "audio/x-musicnet-stream"),
    MOVIE("movie", "video/x-sgi-movie"),
    MP2("mp2", "audio/mp2"),
    MPA("mpa", "video/x-mpg"),
    MPE("mpe", "video/x-mpeg"),
    MPG("mpg", "video/mpg"),
    MPP("mpp", "application/vnd.ms-project"),
    MPT("mpt", "application/vnd.ms-project"),
    MPV2("mpv2", "video/mpeg"),
    MPX("mpx", "application/vnd.ms-project"),
    MXP("mxp", "application/x-mmxp"),
    NRF("nrf", "application/x-nrf"),
    ODC("odc", "text/x-ms-odc"),
    P10("p10", "application/pkcs10"),
    P7B("p7b", "application/x-pkcs7-certificates"),
    P7M("p7m", "application/pkcs7-mime"),
    P7S("p7s", "application/pkcs7-signature"),
    PCI("pci", "application/x-pci"),
    PCX("pcx", "application/x-pcx"),
    PFX("pfx", "application/x-pkcs12"),
    PIC("pic", "application/x-pic"),
    PL("pl", "application/x-perl"),
    PLS("pls", "audio/scpls"),
    POT("pot", "application/vnd.ms-powerpoint"),
    PPM("ppm", "application/x-ppm"),
    PR("pr", "application/x-pr"),
    PRN("prn", "application/x-prn"),
    PTN("ptn", "application/x-ptn"),
    R3T("r3t", "text/vnd.rn-realtext3d"),
    RAM("ram", "audio/x-pn-realaudio"),
    RAT("rat", "application/rat-file"),
    REC("rec", "application/vnd.rn-recording"),
    RGB("rgb", "application/x-rgb"),
    RJT("rjt", "application/vnd.rn-realsystem-rjt"),
    RLE("rle", "application/x-rle"),
    RMF("rmf", "application/vnd.adobe.rmf"),
    RMJ("rmj", "application/vnd.rn-realsystem-rmj"),
    RMP("rmp", "application/vnd.rn-rn_music_package"),
    RMVB("rmvb", "application/vnd.rn-realmedia-vbr"),
    RNX("rnx", "application/vnd.rn-realplayer"),
    RPM("rpm", "audio/x-pn-realaudio-plugin"),
    RT("rt", "text/vnd.rn-realtext"),
    SAM("sam", "application/x-sam"),
    SDP("sdp", "application/sdp"),
    SIT("sit", "application/x-stuffit"),
    SLD("sld", "application/x-sld"),
    SMI("smi", "application/smil"),
    SMK("smk", "application/x-smk"),
    SOL("sol", "text/plain"),
    SPC("spc", "application/x-pkcs7-certificates"),
    SPP("spp", "text/xml"),
    SST("sst", "application/vnd.ms-pki.certstore"),
    STM("stm", "text/html"),
    SVG("svg", "text/xml"),
    TDF("tdf", "application/x-tdf"),
    TGA("tga", "application/x-tga"),
    TLD("tld", "text/xml"),
    TORRENT("torrent", "application/x-bittorrent"),
    ULS("uls", "text/iuls"),
    VDA("vda", "application/x-vda"),
    VML("vml", "text/xml"),
    VSS("vss", "application/vnd.visio"),
    VSX("vsx", "application/vnd.visio"),
    VXML("vxml", "text/xml"),
    WAX("wax", "audio/x-ms-wax"),
    WB2("wb2", "application/x-wb2"),
    WBMP("wbmp", "image/vnd.wap.wbmp"),
    WK3("wk3", "application/x-wk3"),
    WKQ("wkq", "application/x-wkq"),
    WM("wm", "video/x-ms-wm"),
    WMD("wmd", "application/x-ms-wmd"),
    WML("wml", "text/vnd.wap.wml"),
    WMX("wmx", "video/x-ms-wmx"),
    WP6("wp6", "application/x-wp6"),
    WPG("wpg", "application/x-wpg"),
    WQ1("wq1", "application/x-wq1"),
    WRI("wri", "application/x-wri"),
    WS("ws", "application/x-ws"),
    WSC("wsc", "text/scriptlet"),
    WVX("wvx", "video/x-ms-wvx"),
    XDR("xdr", "text/xml"),
    XFDF("xfdf", "application/vnd.adobe.xfdf"),
    XLW("xlw", "application/x-xlw"),
    XPL("xpl", "audio/scpls"),
    XQL("xql", "text/xml"),
    XSD("xsd", "text/xml"),
    XSLT("xslt", "text/xml"),
    X_B("x_b", "application/x-x_b"),
    SISX("sisx", "application/vnd.symbian.install"),
    IPA("ipa", "application/vnd.iphone"),
    XAP("xap", "application/x-silverlight-app");

    private final String typeKey;
    private final String typeValue;

    private CkContentType(String typeKey, String typeValue) {
        this.typeKey = typeKey;
        this.typeValue = typeValue;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public String getTypeValue() {
        return this.typeValue;
    }

    public String getTypeValue(Charset character) {
        return this.typeValue.concat("; charset=").concat(character.toString());
    }

    public static CkContentType getContentBySuffixName(String fileSuffixName) {
        return CkContentType.valueOf(fileSuffixName.toUpperCase());
    }

    public String toString() {
        return this.getTypeKey();
    }
}

