/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.DataFilter;
import com.gomyck.util.log.logger.CkLogger;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CkFile {
    private static final Logger log = LoggerFactory.getLogger(CkFile.class);
    public static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>();

    public static boolean writeFile(String dirPath, Workbook workbook, String fileName) {
        return CkFile.writeFile(dirPath, workbook, fileName, false);
    }

    public static boolean writeFile(String dirPath, Workbook workbook, String fileName, boolean overwrite) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)byteArrayOutputStream);
            return CkFile.writeFile(dirPath, byteArrayOutputStream.toByteArray(), fileName, overwrite);
        }
        catch (IOException e) {
            log.error(CkLogger.getTrace(e));
            return false;
        }
    }

    public static boolean writeFile(String dirPath, byte[] fileInfo, String fileName) {
        return CkFile.writeFile(dirPath, fileInfo, fileName, false);
    }

    public static boolean writeFile(String dirPath, byte[] fileInfo, String fileName, boolean overwrite) {
        boolean ifCreate = false;
        File file = new File(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(dirPath, fileName);
        try {
            if (!file.exists()) {
                ifCreate = file.createNewFile();
            }
            FileOutputStream outStr = new FileOutputStream(file, !overwrite);
            outStr.write(fileInfo);
            outStr.flush();
            outStr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ifCreate;
    }

    public static boolean isImage(InputStream in) {
        try {
            BufferedImage image = ImageIO.read(in);
            if (image == null) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean deleteFile(String dirPath, String fileName) {
        boolean ifDel = false;
        File file = new File(dirPath + File.separator + fileName);
        if (file.exists()) {
            ifDel = file.delete();
        }
        return ifDel;
    }

    public static String[] getFileNameAndSuffix(String fileName) {
        String[] strs = new String[2];
        if (fileName != null && fileName.length() > 0) {
            int i;
            if (fileName.contains(File.separator)) {
                fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
            }
            if ((i = fileName.lastIndexOf(".")) > -1) {
                strs[0] = fileName.substring(0, i);
                strs[1] = fileName.substring(i + 1);
            } else {
                strs[0] = fileName;
                strs[1] = "";
            }
            return strs;
        }
        return new String[]{"unknown", "unknown"};
    }

    public static final String getFileSuffixNameByStream(byte[] b) {
        String defaultSuffix = "txt";
        String fileTypeHex = String.valueOf(CkFile.bytesToHexString(DataFilter.subByte(b, 0, 30)));
        for (Map.Entry<String, String> entry : FILE_TYPE_MAP.entrySet()) {
            String fileTypeHexValue = entry.getValue();
            if (!fileTypeHex.toUpperCase().startsWith(fileTypeHexValue)) continue;
            return entry.getKey();
        }
        return defaultSuffix;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getFileSuffixNameByFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return !ext.contains(String.valueOf('/')) && !ext.contains(String.valueOf('\\')) ? ext : "";
    }

    public static byte[] getFile(String uri) {
        InputStream fileAsInputStream = CkFile.getFileAsInputStream(uri);
        ByteArrayOutputStream outputStream = null;
        try {
            int len;
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = fileAsInputStream.read(buffer)) > -1) {
                outputStream.write(buffer, 0, len);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)fileAsInputStream);
            IOUtils.closeQuietly((Closeable)outputStream);
        }
    }

    public static InputStream getFileAsInputStream(String uri) {
        InputStream fileInputStream = null;
        try {
            if (uri.startsWith("http")) {
                URL urlObj = new URL(uri);
                URLConnection urlConnection = urlObj.openConnection();
                urlConnection.setConnectTimeout(30000);
                urlConnection.setReadTimeout(60000);
                urlConnection.setDoInput(true);
                fileInputStream = urlConnection.getInputStream();
            } else {
                try {
                    fileInputStream = new FileInputStream(uri);
                }
                catch (FileNotFoundException e) {
                    if (uri.startsWith("/")) {
                        uri = uri.replaceFirst("/", "");
                    }
                    if (uri.startsWith("/")) {
                        throw new RuntimeException("Illegal parameter");
                    }
                    fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fileInputStream;
    }

    public static BufferedImage mergeImage(boolean isHorizontal, List<BufferedImage> imgs) {
        BufferedImage destImage = null;
        int allw = 0;
        int allh = 0;
        int allwMax = 0;
        int allhMax = 0;
        for (int i = 0; i < imgs.size(); ++i) {
            BufferedImage img = imgs.get(i);
            allw += img.getWidth();
            allh = imgs.size() != i + 1 ? (allh += img.getHeight() + 2) : (allh += img.getHeight());
            if (img.getWidth() > allwMax) {
                allwMax = img.getWidth();
            }
            if (img.getHeight() <= allhMax) continue;
            allhMax = img.getHeight();
        }
        destImage = isHorizontal ? new BufferedImage(allw, allhMax, 1) : new BufferedImage(allwMax, allh, 1);
        int wx = 0;
        int wy = 0;
        for (int i = 0; i < imgs.size(); ++i) {
            BufferedImage img = imgs.get(i);
            int w1 = img.getWidth();
            int h1 = img.getHeight();
            int[] ImageArrayOne = new int[w1 * h1];
            ImageArrayOne = img.getRGB(0, 0, w1, h1, ImageArrayOne, 0, w1);
            if (isHorizontal) {
                destImage.setRGB(wx, 0, w1, h1, ImageArrayOne, 0, w1);
            } else {
                destImage.setRGB(0, wy, w1, h1, ImageArrayOne, 0, w1);
            }
            wx += w1;
            wy += h1 + 2;
        }
        return destImage;
    }

    static {
        FILE_TYPE_MAP.put("officeX-WORD", "504B0304140006");
        FILE_TYPE_MAP.put("officeX-MIDI", "504B03040A00");
        FILE_TYPE_MAP.put("office-WORD", "D0CF11E0");
        FILE_TYPE_MAP.put("office-EXCEL", "D0CF11E0");
        FILE_TYPE_MAP.put("jpg", "FFD8FF");
        FILE_TYPE_MAP.put("png", "89504E47");
        FILE_TYPE_MAP.put("gif", "47494638");
        FILE_TYPE_MAP.put("tif", "49492A00");
        FILE_TYPE_MAP.put("bmp", "424D");
        FILE_TYPE_MAP.put("dwg", "41433130");
        FILE_TYPE_MAP.put("html", "68746D6C3E");
        FILE_TYPE_MAP.put("rtf", "7B5C727466");
        FILE_TYPE_MAP.put("xml", "3C3F786D6C");
        FILE_TYPE_MAP.put("zip", "504B0304");
        FILE_TYPE_MAP.put("rar", "52617221");
        FILE_TYPE_MAP.put("psd", "38425053");
        FILE_TYPE_MAP.put("eml", "44656C69766572792D646174653A");
        FILE_TYPE_MAP.put("dbx", "CFAD12FEC5FD746F");
        FILE_TYPE_MAP.put("pst", "2142444E");
        FILE_TYPE_MAP.put("mdb", "5374616E64617264204A");
        FILE_TYPE_MAP.put("wpd", "FF575043");
        FILE_TYPE_MAP.put("eps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("ps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("pdf", "255044462D312E");
        FILE_TYPE_MAP.put("qdf", "AC9EBD8F");
        FILE_TYPE_MAP.put("pwl", "E3828596");
        FILE_TYPE_MAP.put("wav", "57415645");
        FILE_TYPE_MAP.put("avi", "41564920");
        FILE_TYPE_MAP.put("ram", "2E7261FD");
        FILE_TYPE_MAP.put("rm", "2E524D46");
        FILE_TYPE_MAP.put("mpg", "000001BA");
        FILE_TYPE_MAP.put("mov", "6D6F6F76");
        FILE_TYPE_MAP.put("asf", "3026B2758E66CF11");
        FILE_TYPE_MAP.put("mid", "4D546864");
    }
}

