/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.CkContentType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CkNetWork {
    private static final Logger log = LoggerFactory.getLogger(CkNetWork.class);
    private static final RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(1000).build();
    private final CookieStore cookieStore = new BasicCookieStore();
    private final HttpClientContext localContext = HttpClientContext.create();
    private final CloseableHttpClient httpclient;
    private PoolingHttpClientConnectionManager connectionManager;

    private CkNetWork(RequestConfig requestConfig, TrustStrategy trustStrategy) {
        this.localContext.setCookieStore(this.cookieStore);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig).useSystemProperties();
        if (trustStrategy != null) {
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)trustStrategy).build();
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                this.connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.connectionManager = new PoolingHttpClientConnectionManager();
        }
        this.connectionManager.setMaxTotal(300);
        this.connectionManager.setDefaultMaxPerRoute(75);
        HttpHost localhost = new HttpHost("localhost", 80);
        this.connectionManager.setMaxPerRoute(new HttpRoute(localhost), 50);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager).useSystemProperties();
        this.httpclient = httpClientBuilder.build();
    }

    public static CkNetWork init() {
        return CkNetWork.init(defaultRequestConfig);
    }

    public static CkNetWork init(RequestConfig requestConfig) {
        return new CkNetWork(requestConfig, null);
    }

    public static CkNetWork init(TrustStrategy trustStrategy) {
        return new CkNetWork(defaultRequestConfig, trustStrategy);
    }

    public static CkNetWork init(RequestConfig requestConfig, TrustStrategy trustStrategy) {
        return new CkNetWork(requestConfig, trustStrategy);
    }

    public HttpPost getPost() {
        return new HttpPost();
    }

    public HttpGet getGet() {
        return new HttpGet();
    }

    /*
     * Exception decompiling
     */
    public FormDataResult doPostFormData(String url, Map<String, String> params, Map<String, File> files) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String doPost(String url, Map<String, String> params) throws IOException {
        return this.doPost(URI.create(url), params);
    }

    public String doPost(URI url, Map<String, String> params) throws IOException {
        HttpPost post = this.getPost();
        log.debug("request uri: {}, params is: {}", (Object)url, params);
        post.setURI(url);
        return this.doPost(post, params);
    }

    public String doPost(HttpPost post, Map<String, String> params) throws IOException {
        log.debug("request uri: {}, params is: {}", (Object)post.getURI().toString(), params);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key)));
        }
        post.addHeader("Content-Type", CkContentType.WWW_FORM_URL_ENCODED.getTypeValue());
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)post, (HttpContext)this.localContext);
        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        log.debug("responseStr is {}", (Object)responseStr);
        return responseStr;
    }

    public String doPost(String url, String jsonEntity) throws IOException {
        return this.doPost(URI.create(url), jsonEntity);
    }

    public String doPost(URI url, String jsonEntity) throws IOException {
        HttpPost post = this.getPost();
        post.setURI(url);
        return this.doPost(post, jsonEntity);
    }

    public String doPost(HttpPost post, String jsonEntity) throws IOException {
        return this.doPost(post, jsonEntity, CkContentType.JSON);
    }

    public String doPost(HttpPost post, String strEntity, CkContentType contentType) throws IOException {
        log.debug("request uri: {}, params is: {}", (Object)post.getURI(), (Object)strEntity);
        post.addHeader("Content-Type", contentType.getTypeValue());
        StringEntity stringEntity = new StringEntity(strEntity, StandardCharsets.UTF_8);
        stringEntity.setContentType(contentType.getTypeValue());
        post.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)post, (HttpContext)this.localContext);
        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        log.debug("responseStr is {}", (Object)responseStr);
        return responseStr;
    }

    public String doPost(String url) throws IOException {
        return this.doPost(URI.create(url));
    }

    public String doPost(URI url) throws IOException {
        log.debug("request uri: {}", (Object)url);
        HttpPost post = new HttpPost();
        post.setURI(url);
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)post, (HttpContext)this.localContext);
        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        log.debug("responseStr is {}", (Object)responseStr);
        return responseStr;
    }

    public String doGet(String uri) throws IOException {
        URI url = URI.create(uri);
        return this.doGet(url);
    }

    public String doGet(URI uri) throws IOException {
        log.debug("request uri: {}", (Object)uri);
        HttpGet get = new HttpGet();
        get.setURI(uri);
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)get, (HttpContext)this.localContext);
        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        log.debug("responseStr is {}", (Object)responseStr);
        return responseStr;
    }

    public String doGet(HttpGet get) throws IOException {
        log.debug("request uri: {}", (Object)get.getURI());
        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)get, (HttpContext)this.localContext);
        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        log.debug("responseStr is {}", (Object)responseStr);
        return responseStr;
    }

    public static boolean isChineseChar(String str) {
        boolean temp = false;
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        if (m.find()) {
            temp = true;
        }
        return temp;
    }

    public byte[] doGetFile(String url) throws IOException {
        int len;
        log.debug("request uri: {}", (Object)url);
        HttpGet httpGet = new HttpGet(URI.create(url));
        InputStream in = this.httpclient.execute((HttpUriRequest)httpGet, (HttpContext)this.localContext).getEntity().getContent();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        in.close();
        return outStream.toByteArray();
    }

    public RequestConfig getProxyConfig(HttpHost host) {
        HttpHost proxy = new HttpHost("127.0.0.1", 8888);
        return RequestConfig.custom().setProxy(host == null ? proxy : host).setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(1000).setCookieSpec("default").build();
    }

    public static SSLContext initAllSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpClientContext getLocalContext() {
        return this.localContext;
    }

    public CloseableHttpClient getHttpclient() {
        return this.httpclient;
    }

    public PoolingHttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(PoolingHttpClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CkNetWork)) {
            return false;
        }
        CkNetWork other = (CkNetWork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CookieStore this$cookieStore = this.getCookieStore();
        CookieStore other$cookieStore = other.getCookieStore();
        if (this$cookieStore == null ? other$cookieStore != null : !this$cookieStore.equals(other$cookieStore)) {
            return false;
        }
        HttpClientContext this$localContext = this.getLocalContext();
        HttpClientContext other$localContext = other.getLocalContext();
        if (this$localContext == null ? other$localContext != null : !this$localContext.equals(other$localContext)) {
            return false;
        }
        CloseableHttpClient this$httpclient = this.getHttpclient();
        CloseableHttpClient other$httpclient = other.getHttpclient();
        if (this$httpclient == null ? other$httpclient != null : !this$httpclient.equals(other$httpclient)) {
            return false;
        }
        PoolingHttpClientConnectionManager this$connectionManager = this.getConnectionManager();
        PoolingHttpClientConnectionManager other$connectionManager = other.getConnectionManager();
        return !(this$connectionManager == null ? other$connectionManager != null : !this$connectionManager.equals(other$connectionManager));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CkNetWork;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CookieStore $cookieStore = this.getCookieStore();
        result = result * 59 + ($cookieStore == null ? 43 : $cookieStore.hashCode());
        HttpClientContext $localContext = this.getLocalContext();
        result = result * 59 + ($localContext == null ? 43 : $localContext.hashCode());
        CloseableHttpClient $httpclient = this.getHttpclient();
        result = result * 59 + ($httpclient == null ? 43 : $httpclient.hashCode());
        PoolingHttpClientConnectionManager $connectionManager = this.getConnectionManager();
        result = result * 59 + ($connectionManager == null ? 43 : $connectionManager.hashCode());
        return result;
    }

    public String toString() {
        return "CkNetWork(cookieStore=" + this.getCookieStore() + ", localContext=" + this.getLocalContext() + ", httpclient=" + this.getHttpclient() + ", connectionManager=" + this.getConnectionManager() + ")";
    }

    private static /* synthetic */ void lambda$doPostFormData$1(MultipartEntityBuilder entityBuilder, Map files, String e) {
        entityBuilder.addBinaryBody(e, (File)files.get(e), ContentType.DEFAULT_BINARY, ((File)files.get(e)).getName());
    }

    private static /* synthetic */ void lambda$doPostFormData$0(MultipartEntityBuilder entityBuilder, Map params, String e) {
        entityBuilder.addTextBody(e, (String)params.get(e), ContentType.TEXT_PLAIN);
    }

    public static class FormDataResult {
        private boolean downloadFlag;
        private String result;
        private byte[] file;

        FormDataResult(boolean downloadFlag, String result, byte[] file) {
            this.downloadFlag = downloadFlag;
            this.result = result;
            this.file = file;
        }

        public static FormDataResultBuilder builder() {
            return new FormDataResultBuilder();
        }

        public boolean isDownloadFlag() {
            return this.downloadFlag;
        }

        public String getResult() {
            return this.result;
        }

        public byte[] getFile() {
            return this.file;
        }

        public void setDownloadFlag(boolean downloadFlag) {
            this.downloadFlag = downloadFlag;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void setFile(byte[] file) {
            this.file = file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FormDataResult)) {
                return false;
            }
            FormDataResult other = (FormDataResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDownloadFlag() != other.isDownloadFlag()) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            return Arrays.equals(this.getFile(), other.getFile());
        }

        protected boolean canEqual(Object other) {
            return other instanceof FormDataResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDownloadFlag() ? 79 : 97);
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            result = result * 59 + Arrays.hashCode(this.getFile());
            return result;
        }

        public String toString() {
            return "CkNetWork.FormDataResult(downloadFlag=" + this.isDownloadFlag() + ", result=" + this.getResult() + ", file=" + Arrays.toString(this.getFile()) + ")";
        }

        public static class FormDataResultBuilder {
            private boolean downloadFlag;
            private String result;
            private byte[] file;

            FormDataResultBuilder() {
            }

            public FormDataResultBuilder downloadFlag(boolean downloadFlag) {
                this.downloadFlag = downloadFlag;
                return this;
            }

            public FormDataResultBuilder result(String result) {
                this.result = result;
                return this;
            }

            public FormDataResultBuilder file(byte[] file) {
                this.file = file;
                return this;
            }

            public FormDataResult build() {
                return new FormDataResult(this.downloadFlag, this.result, this.file);
            }

            public String toString() {
                return "CkNetWork.FormDataResult.FormDataResultBuilder(downloadFlag=" + this.downloadFlag + ", result=" + this.result + ", file=" + Arrays.toString(this.file) + ")";
            }
        }
    }
}

