/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.ObjectJudge;
import com.gomyck.util.servlet.RequestReader;
import com.gomyck.util.servlet.TokenTake;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class CkPage<T> {
    private static boolean adapterInited = false;
    private static Adapter adapter = new Adapter();
    private PageInfo pageInfo = new PageInfo();
    private long pageIndex = this.pageInfo.getPage();
    private long pageSize = this.pageInfo.getLimit();
    private long totalCount = 0L;
    private long totalPageCount;
    private List<T> records = null;

    public static synchronized void setAdapter(Adapter adapter) {
        if (adapterInited) {
            throw new RuntimeException("adaptor has bean inited...");
        }
        if (adapter == null) {
            throw new RuntimeException("adaptor must be not null...");
        }
        CkPage.adapter = adapter;
        adapterInited = true;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public CkPage(List<T> records, long totalCount, long pageIndex, long pageSize) {
        this.totalPageCount = totalCount / pageSize;
        this.totalPageCount = totalCount > this.totalPageCount * pageSize ? this.totalPageCount + 1L : this.totalPageCount;
        this.setRecords(records);
        this.setTotalCount(totalCount);
        this.setPageIndex(pageIndex);
        this.setPageSize(pageSize);
    }

    public CkPage(List<T> records, long totalCount, PageInfo pageInfo) {
        this.totalPageCount = totalCount / pageInfo.getLimit();
        this.totalPageCount = totalCount > this.totalPageCount * pageInfo.getLimit() ? this.totalPageCount + 1L : this.totalPageCount;
        this.setRecords(records);
        this.setTotalCount(totalCount);
        this.setPageIndex(pageInfo.getPage());
        this.setPageSize(pageInfo.getLimit());
    }

    public Map<String, Object> initResult() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(adapter.getData(), this.getRecords());
        map.put(adapter.getPageSize(), this.getPageSize());
        map.put(adapter.getCurrPage(), this.getPageIndex());
        map.put(adapter.getNextPage(), this.getNextIndex());
        map.put(adapter.getPrePage(), this.getPreviousIndex());
        map.put(adapter.getTotalRecords(), this.getTotalCount());
        map.put(adapter.getTotalPages(), this.getTotalPageCount());
        return map;
    }

    public long getTotalPageCount() {
        return this.totalPageCount;
    }

    public static long getStartOfPage(long pageIndex, long pageSize) {
        return pageIndex - 1L >= 0L ? (pageIndex - 1L) * pageSize : 0L;
    }

    public static long getEndOfPage(long pageIndex, long pageSize) {
        return pageIndex * pageSize;
    }

    public long getNextIndex() {
        return Math.min(this.getPageIndex() + 1L, this.getTotalPageCount());
    }

    public long getPreviousIndex() {
        return Math.max(this.getPageIndex() - 1L, 1L);
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(long pageIndex) {
        this.pageIndex = pageIndex <= 1L ? 1L : Math.min(this.getTotalPageCount(), pageIndex);
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public static PageInfo initPageInfoByHeader() {
        return CkPage.initPageInfoByHeader("page", "limit", "orderBy", "orderRule");
    }

    public static PageInfo initPageInfoByHeader(String pageKeyName, String limitKeyName, String orderByName, String orderRuleName) {
        HttpServletRequest request = RequestReader.getRequest();
        if (request == null) {
            return null;
        }
        String page = TokenTake.getToken(request, pageKeyName);
        String limit = TokenTake.getToken(request, limitKeyName);
        String orderBy = TokenTake.getToken(request, orderByName);
        String orderRule = TokenTake.getToken(request, orderRuleName);
        if (ObjectJudge.notNull(page, limit)) {
            try {
                return new PageInfo(Long.parseLong(page), Long.parseLong(limit), orderBy, orderRule);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return MessageFormat.format("PageUtil'{'pageIndex={0}, pageSize={1}, totalCount={2}, totalPageCount={3}, records={4}'}'", this.pageIndex, this.pageSize, this.totalCount, this.totalPageCount, this.records);
    }

    public static class PageInfo {
        private long page = 1L;
        private long limit = 15L;
        private String orderBy;
        private String orderRule;

        public PageInfo() {
        }

        public PageInfo(long page, long limit) {
            this.page = page;
            this.limit = limit;
        }

        public PageInfo(long page, long limit, String orderBy, String orderRule) {
            this.page = page;
            this.limit = limit;
            this.orderBy = orderBy;
            this.orderRule = orderRule;
        }

        public long getStartRowNum() {
            return CkPage.getStartOfPage(this.page, this.limit);
        }

        public long getEndRowNum() {
            return this.page * this.limit;
        }

        public long getPage() {
            return this.page;
        }

        public long getLimit() {
            return this.limit;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public String getOrderRule() {
            return this.orderRule;
        }

        public void setPage(long page) {
            this.page = page;
        }

        public void setLimit(long limit) {
            this.limit = limit;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public void setOrderRule(String orderRule) {
            this.orderRule = orderRule;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageInfo)) {
                return false;
            }
            PageInfo other = (PageInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPage() != other.getPage()) {
                return false;
            }
            if (this.getLimit() != other.getLimit()) {
                return false;
            }
            String this$orderBy = this.getOrderBy();
            String other$orderBy = other.getOrderBy();
            if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
                return false;
            }
            String this$orderRule = this.getOrderRule();
            String other$orderRule = other.getOrderRule();
            return !(this$orderRule == null ? other$orderRule != null : !this$orderRule.equals(other$orderRule));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PageInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $page = this.getPage();
            result = result * 59 + (int)($page >>> 32 ^ $page);
            long $limit = this.getLimit();
            result = result * 59 + (int)($limit >>> 32 ^ $limit);
            String $orderBy = this.getOrderBy();
            result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
            String $orderRule = this.getOrderRule();
            result = result * 59 + ($orderRule == null ? 43 : $orderRule.hashCode());
            return result;
        }

        public String toString() {
            return "CkPage.PageInfo(page=" + this.getPage() + ", limit=" + this.getLimit() + ", orderBy=" + this.getOrderBy() + ", orderRule=" + this.getOrderRule() + ")";
        }
    }

    public static class Adapter {
        private String data = "records";
        private String currPage = "pageIndex";
        private String totalPages = "totalPageCount";
        private String totalRecords = "totalCount";
        private String pageSize = "pageSize";
        private String prePage = "previousIndex";
        private String nextPage = "nextIndex";

        public String getData() {
            return this.data;
        }

        public String getCurrPage() {
            return this.currPage;
        }

        public String getTotalPages() {
            return this.totalPages;
        }

        public String getTotalRecords() {
            return this.totalRecords;
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public String getPrePage() {
            return this.prePage;
        }

        public String getNextPage() {
            return this.nextPage;
        }

        public void setData(String data) {
            this.data = data;
        }

        public void setCurrPage(String currPage) {
            this.currPage = currPage;
        }

        public void setTotalPages(String totalPages) {
            this.totalPages = totalPages;
        }

        public void setTotalRecords(String totalRecords) {
            this.totalRecords = totalRecords;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public void setPrePage(String prePage) {
            this.prePage = prePage;
        }

        public void setNextPage(String nextPage) {
            this.nextPage = nextPage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Adapter)) {
                return false;
            }
            Adapter other = (Adapter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$currPage = this.getCurrPage();
            String other$currPage = other.getCurrPage();
            if (this$currPage == null ? other$currPage != null : !this$currPage.equals(other$currPage)) {
                return false;
            }
            String this$totalPages = this.getTotalPages();
            String other$totalPages = other.getTotalPages();
            if (this$totalPages == null ? other$totalPages != null : !this$totalPages.equals(other$totalPages)) {
                return false;
            }
            String this$totalRecords = this.getTotalRecords();
            String other$totalRecords = other.getTotalRecords();
            if (this$totalRecords == null ? other$totalRecords != null : !this$totalRecords.equals(other$totalRecords)) {
                return false;
            }
            String this$pageSize = this.getPageSize();
            String other$pageSize = other.getPageSize();
            if (this$pageSize == null ? other$pageSize != null : !this$pageSize.equals(other$pageSize)) {
                return false;
            }
            String this$prePage = this.getPrePage();
            String other$prePage = other.getPrePage();
            if (this$prePage == null ? other$prePage != null : !this$prePage.equals(other$prePage)) {
                return false;
            }
            String this$nextPage = this.getNextPage();
            String other$nextPage = other.getNextPage();
            return !(this$nextPage == null ? other$nextPage != null : !this$nextPage.equals(other$nextPage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Adapter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $currPage = this.getCurrPage();
            result = result * 59 + ($currPage == null ? 43 : $currPage.hashCode());
            String $totalPages = this.getTotalPages();
            result = result * 59 + ($totalPages == null ? 43 : $totalPages.hashCode());
            String $totalRecords = this.getTotalRecords();
            result = result * 59 + ($totalRecords == null ? 43 : $totalRecords.hashCode());
            String $pageSize = this.getPageSize();
            result = result * 59 + ($pageSize == null ? 43 : $pageSize.hashCode());
            String $prePage = this.getPrePage();
            result = result * 59 + ($prePage == null ? 43 : $prePage.hashCode());
            String $nextPage = this.getNextPage();
            result = result * 59 + ($nextPage == null ? 43 : $nextPage.hashCode());
            return result;
        }

        public String toString() {
            return "CkPage.Adapter(data=" + this.getData() + ", currPage=" + this.getCurrPage() + ", totalPages=" + this.getTotalPages() + ", totalRecords=" + this.getTotalRecords() + ", pageSize=" + this.getPageSize() + ", prePage=" + this.getPrePage() + ", nextPage=" + this.getNextPage() + ")";
        }
    }
}

