/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FieldUtil {
    private static final Map<Class<?>, List<Field>> cache = new ConcurrentHashMap();

    public static List<Field> getAllFields(Class clazz) {
        if (cache.get(clazz) != null) {
            return cache.get(clazz);
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        cache.put(clazz, fieldList);
        return fieldList;
    }

    public static Class<?> getBaseType(String typeName) {
        Object[][] baseTypes;
        for (Object[] type : baseTypes = new Object[][]{{"byte", Byte.TYPE}, {"short", Short.TYPE}, {"char", Character.TYPE}, {"int", Integer.TYPE}, {"long", Long.TYPE}, {"float", Float.TYPE}, {"double", Double.TYPE}, {"boolean", Boolean.TYPE}}) {
            if (!type[0].equals(typeName)) continue;
            return (Class)type[1];
        }
        return null;
    }

    public static Class<?> getWrapperBaseType(String typeName) {
        Object[][] baseTypes = new Object[][]{{"java.lang.Byte", Byte.class}, {"java.lang.Short", Short.class}, {"java.lang.Character", Character.class}, {"java.lang.Integer", Integer.class}, {"java.lang.Long", Long.class}, {"java.lang.Float", Float.class}, {"java.lang.Double", Double.class}, {"java.lang.Boolean", Boolean.class}};
        for (int i = 0; i < baseTypes.length; ++i) {
            Object[] type = baseTypes[i];
            if (!type[0].equals(typeName)) continue;
            return (Class)type[1];
        }
        return null;
    }

    public static boolean isBaseType(Object param) {
        if (param == null) {
            return false;
        }
        return param.getClass().isPrimitive();
    }

    public static boolean isWrapperBaseType(Object param) {
        return FieldUtil.getWrapperBaseType(param.getClass().getTypeName()) != null;
    }

    public static boolean isJDKClass(Object object) {
        return object.getClass().getClassLoader() == null || object.getClass().isEnum() || object.getClass().isAnnotation();
    }

    public static Class<?> wrapperPrimitiveExchange(Class<?> param) {
        Object[][] baseTypes = new Object[][]{{Byte.TYPE, Byte.class}, {Short.TYPE, Short.class}, {Character.TYPE, Character.class}, {Integer.TYPE, Integer.class}, {Long.TYPE, Long.class}, {Float.TYPE, Float.class}, {Double.TYPE, Double.class}, {Boolean.TYPE, Boolean.class}};
        for (int i = 0; i < baseTypes.length; ++i) {
            Object[] type = baseTypes[i];
            if (type[1].equals(param)) {
                return (Class)type[0];
            }
            if (!type[0].equals(param)) continue;
            return (Class)type[1];
        }
        return null;
    }

    public static Method getMethod(Class clazz, String fieldName) {
        String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        String getMethodName = "get" + suffix;
        try {
            return clazz.getMethod(getMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getMethodName = "is" + suffix;
            try {
                return clazz.getMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }

    public static Method setMethod(Class clazz, String fieldName) {
        Method[] methods;
        String setterMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(setterMethodName) || method.getParameterCount() != 1) continue;
            return method;
        }
        return null;
    }
}

