/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.ObjectJudge;
import com.gomyck.util.UnicodeUtil;
import java.nio.charset.StandardCharsets;

public class HexUtil {
    public static final String HEX_DIC = "0123456789ABCDEF";

    public static String hex2String(String hexStr, String delimiter) {
        if (ObjectJudge.isNull((Object)hexStr)) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        hexStr = hexStr.toUpperCase();
        hexStr = hexStr.replaceAll(delimiter, "");
        char[] hexChars = hexStr.toCharArray();
        byte[] strBytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < strBytes.length; ++i) {
            int hexNum = HEX_DIC.indexOf(hexChars[2 * i]) * 16;
            strBytes[i] = (byte)((hexNum += HEX_DIC.indexOf(hexChars[2 * i + 1])) & 0xFF);
        }
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    public static String string2Hex(String str, String delimiter) {
        if (ObjectJudge.isNull((Object)str)) {
            return null;
        }
        if (ObjectJudge.isNull((Object)delimiter)) {
            delimiter = "";
        }
        char[] hexCharsDic = HEX_DIC.toCharArray();
        StringBuilder sb = new StringBuilder();
        byte[] strBytes = str.getBytes();
        for (int i = 0; i < strBytes.length; ++i) {
            int hexIndex = (strBytes[i] & 0xF0) >> 4;
            sb.append(hexCharsDic[hexIndex]);
            hexIndex = strBytes[i] & 0xF;
            sb.append(hexCharsDic[hexIndex]);
            if (i == strBytes.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString().trim();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(UnicodeUtil.string2Unicode("\u4f60\u597d\u4e2d\u56fd"));
        System.out.println(HexUtil.string2Hex("\u4f60\u597d\u4e2d\u56fd", "-"));
        System.out.println(HexUtil.hex2String("47 45 54 20 63 68 65 63 6b 20 48 54 54 50 2f 31 2e 31 0d 0a 0d 0a", " "));
        System.out.println(3);
    }
}

