/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.CkFile;
import com.gomyck.util.log.logger.CkLogger;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(PDFUtil.class);
    private PdfWriter instance;
    private final Document document = new Document();
    private Object component;
    private Consumer<String> consumer;

    public PDFUtil() {
        this.document.addTitle("PDF");
        this.document.addAuthor("medness");
        this.document.addSubject("PDF");
        this.document.addKeywords("PDF");
        this.document.addCreator("medness");
    }

    public static PDFUtil<?> init(String outFilePath) {
        PDFUtil pdfUtil = new PDFUtil();
        try {
            pdfUtil.instance = PdfWriter.getInstance((Document)pdfUtil.document, (OutputStream)new FileOutputStream(outFilePath));
            pdfUtil.document.open();
            return pdfUtil;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            throw new RuntimeException("PDFUtil init error", e);
        }
    }

    public T getComponent() {
        return (T)this.component;
    }

    public void doConsumer(String nextStepInfo) {
        if (this.consumer != null) {
            this.consumer.accept(nextStepInfo);
            this.consumer = null;
        }
    }

    public PDFUtil<Image> addImage(String imagePath) {
        this.doConsumer("addImage");
        try {
            String[] fileNameAndSuffix = CkFile.getFileNameAndSuffix(imagePath);
            Image image = Image.getInstance((String)imagePath);
            Paragraph filename = new Paragraph(fileNameAndSuffix[0] + "." + fileNameAndSuffix[1]);
            filename.setAlignment(1);
            this.component = image;
            this.consumer = e -> {
                try {
                    log.debug("start add image, next step is: {}", e);
                    this.document.add((Element)image);
                    this.document.add((Element)filename);
                }
                catch (DocumentException ex) {
                    throw new RuntimeException(ex);
                }
            };
            return this;
        }
        catch (Exception e2) {
            log.error(CkLogger.getTrace(e2));
            throw new RuntimeException("PDFUtil addImage error", e2);
        }
    }

    public PDFUtil<Paragraph> addText(String message, int elementAlign) {
        this.doConsumer("addText");
        Paragraph paragraph = new Paragraph(message);
        paragraph.setAlignment(elementAlign);
        this.component = paragraph;
        this.consumer = e -> {
            try {
                log.debug("start add text, next step is: {}", e);
                this.document.add((Element)paragraph);
            }
            catch (DocumentException ex) {
                throw new RuntimeException(ex);
            }
        };
        return this;
    }

    public void close() {
        this.doConsumer("close");
        try {
            this.document.close();
            this.instance.close();
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            throw new RuntimeException("PDFUtil close error", e);
        }
    }
}

