/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.ObjectJudge;
import java.io.UnsupportedEncodingException;

public class PinyinUtil {
    private static final int[] li_SecPosValue = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5590};
    private static final String[] lc_FirstLetter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "w", "x", "y", "z"};

    public static String getAllFirstLetter(String str) {
        if (ObjectJudge.isNull((Object)str)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            stringBuilder.append(PinyinUtil.getFirstLetter(str.substring(i, i + 1)));
        }
        return stringBuilder.toString();
    }

    public static String getFirstLetter(String chinese) {
        if (ObjectJudge.isNull((Object)chinese)) {
            return "";
        }
        chinese = chinese.substring(0, 1);
        if ((chinese = PinyinUtil.conversionStr(chinese, "GB2312", "ISO8859-1")).length() > 1) {
            int li_SectorCode = chinese.charAt(0);
            int li_PositionCode = chinese.charAt(1);
            int li_SecPosCode = (li_SectorCode -= 160) * 100 + (li_PositionCode -= 160);
            if (li_SecPosCode > 1600 && li_SecPosCode < 5590) {
                for (int i = 0; i < 23; ++i) {
                    if (li_SecPosCode < li_SecPosValue[i] || li_SecPosCode >= li_SecPosValue[i + 1]) continue;
                    chinese = lc_FirstLetter[i];
                    break;
                }
            } else {
                chinese = PinyinUtil.conversionStr(chinese, "ISO8859-1", "GB2312");
                chinese = chinese.substring(0, 1);
            }
        }
        return chinese;
    }

    private static String conversionStr(String str, String charsetName, String toCharsetName) {
        try {
            str = new String(str.getBytes(charsetName), toCharsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }
}

