/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;

public class PropertyAppender {
    private static final Logger log = LoggerFactory.getLogger(PropertyAppender.class);

    public static Object generate(Object dest, Map<String, Object> kvMap) throws InvocationTargetException, IllegalAccessException {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        PropertyDescriptor[] descriptorArr = propertyUtilsBean.getPropertyDescriptors(dest);
        HashMap oldKeyMap = new HashMap(8);
        for (PropertyDescriptor it : descriptorArr) {
            if ("class".equalsIgnoreCase(it.getName())) continue;
            oldKeyMap.put(it.getName(), it.getPropertyType());
            kvMap.put(it.getName(), it.getReadMethod().invoke(dest, new Object[0]));
        }
        kvMap.forEach((k, v) -> {
            if (Objects.isNull(v)) {
                return;
            }
            if (oldKeyMap.containsKey(k)) {
                return;
            }
            oldKeyMap.put((String)k, v.getClass());
        });
        DynamicBean dynamicBean = new DynamicBean(dest.getClass(), oldKeyMap);
        kvMap.forEach((x$0, x$1) -> dynamicBean.setValue(x$0, x$1));
        return dynamicBean.getTarget();
    }

    public static Object getValue(Object target, String propKey) {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        try {
            return propertyUtilsBean.getProperty(target, propKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class DynamicBean {
        private final Object target;
        private final BeanMap beanMap;

        private DynamicBean(Class<?> superclass, Map<Object, Class<?>> propertyMap) {
            this.target = this.generateBean(superclass, propertyMap);
            this.beanMap = BeanMap.create((Object)this.target);
        }

        private void setValue(Object property, Object value) {
            this.beanMap.put(property, value);
        }

        private Object getValue(Object property) {
            return this.beanMap.get(property);
        }

        private Object getTarget() {
            return this.target;
        }

        private Object generateBean(Class<?> superclass, Map<Object, Class<?>> propertyMap) {
            BeanGenerator generator = new BeanGenerator();
            if (null != superclass) {
                generator.setSuperclass(superclass);
            }
            BeanGenerator.addProperties((BeanGenerator)generator, propertyMap);
            return generator.create();
        }
    }
}

