/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.DataFilter;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdWorker {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeIdWorker.class);
    private static final String CK_WORK_ID = "CK_WORK_ID";
    private static final String CK_DATA_ID = "CK_DATA_ID";
    private static final long startTime = 1489111900000L;
    private static final long workerIdBits = 5L;
    private static final long sequenceBits = 11L;
    private static final long dataCenterIdBits = 6L;
    private static final long maxWorkerId = 31L;
    private static final long maxDataCenterId = 63L;
    private static final long workerIdShift = 11L;
    private static final long dataCenterIdShift = 16L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 2047L;
    private static long workerId;
    private static long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static final SnowflakeIdWorker idWorker;

    public SnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 63L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenterId can't be greater than %d or less than 0", 63L));
        }
        SnowflakeIdWorker.workerId = workerId;
        SnowflakeIdWorker.dataCenterId = dataCenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x7FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1489111900000L << 22 | dataCenterId << 16 | workerId << 11 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    private static Long getWorkId() {
        try {
            int[] ints = StringUtils.toCodePoints((CharSequence)Inet4Address.getLocalHost().getHostAddress());
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return (long)sums % 32L;
        }
        catch (UnknownHostException e) {
            return RandomUtils.nextLong((long)0L, (long)31L);
        }
    }

    private static Long getDataCenterId() {
        try {
            int[] ints = StringUtils.toCodePoints((CharSequence)Inet4Address.getLocalHost().getHostName());
            int sums = 0;
            for (int i : ints) {
                sums += i;
            }
            return (long)sums % 64L;
        }
        catch (Exception e) {
            return RandomUtils.nextLong((long)0L, (long)31L);
        }
    }

    public static synchronized Long generateId() {
        return idWorker.nextId();
    }

    static {
        String workId = System.getenv(CK_WORK_ID);
        String dataId = System.getenv(CK_DATA_ID);
        idWorker = new SnowflakeIdWorker(Long.parseLong(DataFilter.getFirstNotNull(workId, SnowflakeIdWorker.getWorkId()).toString()), Long.parseLong(DataFilter.getFirstNotNull(dataId, SnowflakeIdWorker.getDataCenterId()).toString()));
        log.info("SnowflakeIdWorker initialized, dataCenterId {} workerId {}", (Object)dataCenterId, (Object)workerId);
    }
}

