/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util;

import com.gomyck.util.CkParam;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.log.logger.CkLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(SqlBuilder.class);

    public static String buildSqlCondition(Map<String, String> map) {
        StringBuffer str = new StringBuffer();
        if (map == null) {
            return "";
        }
        for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
            String key = stringStringEntry.getKey();
            String value = stringStringEntry.getValue();
            if (ObjectJudge.isNull((Object)value)) continue;
            str.append(" AND ").append(CkParam.humpToUnderline(key)).append("='").append(value).append("'");
        }
        return str.toString();
    }

    public static String buildSqlCondition(Map<String, String> map, String tableAlias) {
        StringBuffer str = new StringBuffer();
        if (map == null) {
            return "";
        }
        for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
            String key = stringStringEntry.getKey();
            String value = stringStringEntry.getValue();
            if (ObjectJudge.isNull((Object)value)) continue;
            str.append(" AND ").append(tableAlias).append(".").append(CkParam.humpToUnderline(key)).append("='").append(value).append("'");
        }
        return str.toString();
    }

    public static String buildSqlCondition(Object obj, boolean ifHasWhere) {
        StringBuffer sql = new StringBuffer(ifHasWhere ? " WHERE " : " AND ");
        Class<?> clazz = obj.getClass();
        Field[] filds = clazz.getDeclaredFields();
        boolean ifFirst = true;
        for (Field fild : filds) {
            String fieldName = fild.getName();
            fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method method = clazz.getMethod("get" + fieldName, new Class[0]);
                Object value = method.invoke(obj, new Object[0]);
                if (value == null) continue;
                if (ifFirst) {
                    sql.append(fieldName.toUpperCase() + " = ? ");
                    ifFirst = false;
                    continue;
                }
                sql.append(" AND " + fieldName.toUpperCase() + " = ? ");
            }
            catch (Exception e) {
                log.error(CkLogger.getTrace(e));
            }
        }
        if (ifFirst) {
            return "";
        }
        return sql.toString();
    }

    public static Object[] buildSqlCondition(Object obj) {
        Class<?> clazz = obj.getClass();
        Field[] filds = clazz.getDeclaredFields();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field fild : filds) {
            String fieldName = fild.getName();
            fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method method = clazz.getMethod("get" + fieldName, new Class[0]);
                Object value = method.invoke(obj, new Object[0]);
                if (value == null) continue;
                list.add(value);
            }
            catch (Exception e) {
                log.error(CkLogger.getTrace(e));
            }
        }
        Object[] objs = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objs[i] = list.get(i);
        }
        return objs;
    }

    public static String buildInStr(boolean ifHasBracket, Object ... strs) {
        if (ObjectJudge.isNull(strs)) {
            return "";
        }
        StringBuilder params = new StringBuilder(ifHasBracket ? "(" : "");
        for (Object id : strs) {
            if (ObjectJudge.isNull(id)) continue;
            params.append("'").append(id).append("'").append(",");
        }
        return params.toString().substring(0, params.length() - 1) + (ifHasBracket ? ")" : "");
    }
}

