/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.encrypt;

import com.gomyck.util.HexUtil;
import com.gomyck.util.encrypt.AlgorithmEnum;
import com.gomyck.util.encrypt.RSAUtil;
import com.gomyck.util.log.logger.CkLogger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGen {
    private static final Logger log = LoggerFactory.getLogger(KeyGen.class);

    public String genAES() {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(AlgorithmEnum.AES_CBC_PKCS5PADDING.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyGenerator.init(256, new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] encryptKeyBytes = secretKey.getEncoded();
        String key = HexUtil.bytesToHex(encryptKeyBytes);
        log.info("Generated Encrypt Key: {}", (Object)key);
        return key;
    }

    public String genDES() {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(AlgorithmEnum.DES_CBC_PKCS5PADDING.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyGenerator.init(8, new SecureRandom());
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] encryptKeyBytes = secretKey.getEncoded();
        String key = HexUtil.bytesToHex(encryptKeyBytes);
        log.info("Generated Encrypt Key: {}", (Object)key);
        return key;
    }

    public static Map<String, String> genRsa(int length) {
        KeyPairGenerator keyPairGen = null;
        try {
            keyPairGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
        }
        keyPairGen.initialize(length, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        try {
            String publicKeyString = RSAUtil.base64Encode(publicKey.getEncoded());
            String privateKeyString = RSAUtil.base64Encode(privateKey.getEncoded());
            HashMap<String, String> keyMap = new HashMap<String, String>(2);
            keyMap.put("pub_key", publicKeyString);
            keyMap.put("pri_key", privateKeyString);
            log.info("Generated Encrypt Private Key: {}", (Object)privateKeyString);
            log.info("Generated Encrypt Public Key: {}", (Object)publicKeyString);
            return keyMap;
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    public static void main(String[] args) {
        KeyGen.genRsa(4096);
    }
}

