/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.encrypt;

import com.gomyck.util.log.logger.CkLogger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtil {
    private static final Logger log = LoggerFactory.getLogger(RSAUtil.class);
    private static final String PUBLIC_KEY = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAunU7Z0pgTlCFNtl7CwJu09eHaPFLTkwXHpAbBx+BgSboUxyq+vaJ3sumTwSS7mjJIWUOXcB0lia9mD7A/k91XmnwLZsS77wLGAMP9bKRXMqA7U/gHYohKBzOr76FHfrcKF3fASl44zy3tML4Oo9f+ktTfQoeRInCejXef5npdWjqJsLTBhKjttEBYyp9xBhs2yT02lnkDCkViimG5tBvcmtu9rZ8igbHPXnbCJWZA8sHQQpoAhtama5ndQPZMwks3f+QABJRXu1rvoAEqnV3EgCC3cZqYiuWMiScSNFP7v1+a6yjwdVvvE89VMbY9DN2YGWp3O3xPisvSLtfrfeeVHBVnqUe0t4laQfdxQTAD8ghMl9UgnbycAcaWBWOAnmmCiUFlSzsWOx/zAjEB3y0eARUJxqPv5qKprk5zXIOdhLx5JESvWOadgPgfxzTTygodM44LL7xM0upCYOIq8LIQYFbRZpJCWFpd8xBxmGlhzrSIEBBJMdd8FIVeGsDgcTR7YY0NZjQElBSz9PP6hqhhK/t1drui9nkvTUUOdqLZve4aFgW8b0d+9X6KjqLCGO+RJ0oaObJxOYQEpal4Dx7mtTTgVup1bRjh7TCxHzt3juFFqPHPolzRJAlZmyCnul0l86d0tN/UEhuudfccCSwGB1VTqblCcTK5NdIn/rnVLUCAwEAAQ==";
    private static final String PRIVATE_KEY = "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";

    public static RSAPublicKey loadPublicKeyByStr(String publicKeyStr) {
        try {
            byte[] buffer = RSAUtil.base64Decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    public static RSAPrivateKey loadPrivateKeyByStr(String privateKeyStr) throws Exception {
        try {
            byte[] buffer = RSAUtil.base64Decode(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
            return null;
        }
    }

    public static byte[] encrypt(RSAPublicKey publicKey, byte[] plainTextData) throws Exception {
        if (publicKey == null) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(1, publicKey);
            return cipher.doFinal(plainTextData);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static byte[] encrypt(RSAPrivateKey privateKey, byte[] plainTextData) throws Exception {
        if (privateKey == null) {
            throw new Exception("\u52a0\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(1, privateKey);
            byte[] output = cipher.doFinal(plainTextData);
            return output;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static byte[] decrypt(RSAPrivateKey privateKey, byte[] cipherData) throws Exception {
        if (privateKey == null) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(2, privateKey);
            return cipher.doFinal(cipherData);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static byte[] decrypt(RSAPublicKey publicKey, byte[] cipherData) throws Exception {
        if (publicKey == null) {
            throw new Exception("\u89e3\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA", (Provider)new BouncyCastleProvider());
            cipher.init(2, publicKey);
            return cipher.doFinal(cipherData);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static String base64Encode(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    public static byte[] base64Decode(String data) {
        return Base64.decodeBase64((String)data);
    }

    public static void main(String[] args) {
        try {
            byte[] encrypt = RSAUtil.encrypt(RSAUtil.loadPrivateKeyByStr(PRIVATE_KEY), "\u6211\u64e6\u64e6\u64e6czxczxczqweqw3121231asd".getBytes());
            byte[] decrypt = RSAUtil.decrypt(RSAUtil.loadPublicKeyByStr(PUBLIC_KEY), encrypt);
            System.out.println(new String(decrypt));
        }
        catch (Exception e) {
            log.error(CkLogger.getTrace(e));
        }
    }
}

