/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.jwt;

import com.gomyck.util.AutoConfig;
import com.gomyck.util.jwt.JwtToken;
import com.gomyck.util.jwt.mvc.JwtMvcConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ConfigurationProperties(prefix="gomyck.jwt.token")
public class JwtAutoConfig
implements AutoConfig {
    static final String CK_PREFIX = "gomyck.jwt.token";
    private String secret = "hy123321";
    private int expiration = 360;
    private boolean validate = false;

    @Bean(value={"ckJwtToken"})
    public JwtToken initJwtToken() {
        return new JwtToken();
    }

    @Bean
    @DependsOn(value={"ckJwtToken"})
    @ConditionalOnBean(value={WebMvcAutoConfiguration.class})
    @ConditionalOnProperty(prefix="gomyck.jwt.token", value={"validate"}, havingValue="true")
    public JwtMvcConfig initJwtMvcConfig() {
        return new JwtMvcConfig();
    }

    public String getSecret() {
        return this.secret;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAutoConfig)) {
            return false;
        }
        JwtAutoConfig other = (JwtAutoConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpiration() != other.getExpiration()) {
            return false;
        }
        if (this.isValidate() != other.isValidate()) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtAutoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getExpiration();
        result = result * 59 + (this.isValidate() ? 79 : 97);
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }

    public String toString() {
        return "JwtAutoConfig(secret=" + this.getSecret() + ", expiration=" + this.getExpiration() + ", validate=" + this.isValidate() + ")";
    }
}

