/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.jwt;

import com.gomyck.util.CkId;
import com.gomyck.util.DataFilter;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.jwt.JwtAutoConfig;
import com.gomyck.util.jwt.session.CkSessionUser;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class JwtToken {
    private static final String CUSTOM_KEY_CREATED_TIME = "created";
    @Autowired
    JwtAutoConfig jwtAutoConfig;

    public Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(this.jwtAutoConfig.getSecret()).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    public String getUserName(String token) {
        String username;
        try {
            username = this.getClaimsFromToken(token).getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    public String getUserId(String token) {
        String userId;
        try {
            userId = this.getClaimsFromToken(token).getAudience();
        }
        catch (Exception e) {
            userId = null;
        }
        return userId;
    }

    public Date getCreatedDateFromToken(String token) {
        Date created;
        try {
            Claims claims = this.getClaimsFromToken(token);
            created = new Date((Long)claims.get((Object)CUSTOM_KEY_CREATED_TIME));
        }
        catch (Exception e) {
            created = null;
        }
        return created;
    }

    public String getTokenId(String token) {
        try {
            String id = this.getClaimsFromToken(token).getId();
            return id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getExpirationDateFromToken(String token) {
        Date expiration;
        try {
            Claims claims = this.getClaimsFromToken(token);
            expiration = claims.getExpiration();
        }
        catch (Exception e) {
            expiration = null;
        }
        return expiration;
    }

    public String generateToken(CkSessionUser ckSessionUser) {
        return this.generateToken(ckSessionUser, ckSessionUser.getPubInfo());
    }

    public <T extends Map> String generateToken(CkSessionUser ckSessionUser, T pub) {
        DefaultClaims _claims = new DefaultClaims();
        if (ObjectJudge.notNull((Object)ckSessionUser.getTokenId())) {
            _claims.setId(ckSessionUser.getTokenId());
        } else {
            _claims.setId(CkId.initBatchNo());
        }
        _claims.setAudience(ckSessionUser.getUserId());
        try {
            _claims.setSubject(URLEncoder.encode(DataFilter.toString(ckSessionUser.getUserName()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            _claims.setSubject(ckSessionUser.getUserName());
        }
        _claims.put((Object)CUSTOM_KEY_CREATED_TIME, (Object)new Date());
        if (pub != null) {
            _claims.putAll(pub);
        }
        return this.generateToken((Map<String, Object>)_claims);
    }

    public String refreshToken(String token) {
        String refreshedToken;
        try {
            Claims claims = this.getClaimsFromToken(token);
            claims.put((Object)CUSTOM_KEY_CREATED_TIME, (Object)new Date());
            refreshedToken = this.generateToken((Map<String, Object>)claims);
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    public Boolean validateToken(String token, CkSessionUser user) {
        return this.validateToken(token, token, user);
    }

    public Boolean validateToken(String token, String oToken, CkSessionUser user) {
        if (ObjectJudge.isNull((Object)token) || ObjectJudge.isNull((Object)oToken)) {
            return false;
        }
        if (user == null) {
            return false;
        }
        String username = this.getUserName(token);
        return username.equals(user.getUserName()) && this.isTokenExpired(token) == false && this.getTokenId(oToken).equals(this.getTokenId(token));
    }

    public Boolean validateToken(String token) {
        if (ObjectJudge.isNull((Object)token)) {
            return false;
        }
        Claims claimsFromToken = this.getClaimsFromToken(token);
        if (claimsFromToken == null) {
            return false;
        }
        return this.isTokenExpired(token) == false;
    }

    private Date generateExpirationDate() {
        Calendar instance = Calendar.getInstance();
        instance.add(10, this.jwtAutoConfig.getExpiration());
        return instance.getTime();
    }

    private String generateToken(Map<String, Object> claims) {
        return Jwts.builder().setClaims(claims).setExpiration(this.generateExpirationDate()).signWith(SignatureAlgorithm.HS512, this.jwtAutoConfig.getSecret()).compact();
    }

    private Boolean isTokenExpired(String token) {
        try {
            Date expiration = this.getExpirationDateFromToken(token);
            return expiration.before(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }
}

