/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.jwt.mvc;

import com.gomyck.util.jwt.JwtToken;
import com.gomyck.util.servlet.R;
import com.gomyck.util.servlet.ResponseWriter;
import com.gomyck.util.servlet.TokenTake;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthInterceptor
implements HandlerInterceptor {
    private final JwtToken jwtToken;
    private final List<String> whiteList = new Vector<String>();
    private final List<String> blackList = new Vector<String>();

    public AuthInterceptor(JwtToken jwtToken) {
        this.jwtToken = jwtToken;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String requestURI = request.getRequestURI();
        if (this.whiteList.contains(requestURI)) {
            return true;
        }
        if (this.blackList.contains(requestURI)) {
            return false;
        }
        String token = TokenTake.getToken(request);
        if (!this.jwtToken.validateToken(token).booleanValue()) {
            ResponseWriter.write(R.error(888, "\u672a\u8ba4\u8bc1"));
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String token = TokenTake.getToken(request);
        response.addHeader("Authorization", this.jwtToken.refreshToken(token));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public JwtToken getJwtToken() {
        return this.jwtToken;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public List<String> getBlackList() {
        return this.blackList;
    }
}

