/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.log;

import com.gomyck.util.AutoConfig;
import com.gomyck.util.CkId;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.jwt.session.SimpleCkSessionUser;
import com.gomyck.util.log.adapter.UserInfoAdapter;
import com.gomyck.util.log.annotation.SysLog;
import com.gomyck.util.log.logger.CkLogger;
import com.gomyck.util.log.logger.LogInfo;
import com.gomyck.util.servlet.HttpServletRequestClone;
import com.gomyck.util.servlet.RequestReader;
import com.gomyck.util.servlet.TokenConverter;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Aspect
@Configuration
public class LoggerAutoConfig
implements ApplicationContextAware,
AutoConfig {
    private static final Logger log = LoggerFactory.getLogger(LoggerAutoConfig.class);
    private ApplicationContext applicationContext;
    public static final String CK_LOG_ID = "CK_LOG_ID";

    @Bean
    @ConditionalOnMissingBean(value={UserInfoAdapter.class})
    public UserInfoAdapter initUserInfoAdapter() {
        return request -> TokenConverter.convertTokenInfo(SimpleCkSessionUser.class, request.getToken());
    }

    @Bean
    public CkLogger initCkLogger() {
        log.info("Initialized CkLogger ...");
        return new CkLogger();
    }

    @Around(value="@annotation(com.gomyck.util.log.annotation.SysLog)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        SysLog syslog = method.getAnnotation(SysLog.class);
        LogInfo logInfo = new LogInfo();
        if (syslog != null) {
            Environment environment = this.applicationContext.getEnvironment();
            logInfo.setPlatform(ObjectJudge.isNull((Object)syslog.platform()) ? environment.getProperty("spring.application.name") : syslog.platform());
            String mdc = syslog.mdc();
            if (ObjectJudge.notNull((Object)mdc)) {
                String mdcLogId = MDC.get((String)syslog.mdc());
                if (ObjectJudge.notNull((Object)mdcLogId)) {
                    logInfo.setLogId(mdcLogId);
                } else {
                    logInfo.setLogId(CkId.getSnowflakeId().toString());
                    MDC.put((String)mdc, (String)logInfo.getLogId());
                }
            }
        }
        try {
            Object result = point.proceed();
            this.saveLog(point, syslog, logInfo, beginTime, result);
            Object object = result;
            return object;
        }
        catch (Exception e) {
            this.saveLog(point, syslog, logInfo, beginTime, e);
            throw e;
        }
        finally {
            MDC.remove((String)CK_LOG_ID);
        }
    }

    private void saveLog(ProceedingJoinPoint point, SysLog syslog, LogInfo logInfo, long beginTime, Object result) {
        long time = System.currentTimeMillis() - beginTime;
        HttpServletRequestClone httpServletRequestClone = new HttpServletRequestClone(RequestReader.getRequest());
        String threadName = Thread.currentThread().getName();
        this.initCkLogger().saveSysLog(point, syslog, logInfo, time, result, threadName, httpServletRequestClone);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

