/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.log.logger;

import com.gomyck.util.CkDate;
import com.gomyck.util.CkId;
import com.gomyck.util.CkIp;
import com.gomyck.util.DataFilter;
import com.gomyck.util.ObjectJudge;
import com.gomyck.util.jwt.session.SimpleCkSessionUser;
import com.gomyck.util.log.adapter.LoggerAdapter;
import com.gomyck.util.log.annotation.SysLog;
import com.gomyck.util.log.logger.CkLogService;
import com.gomyck.util.log.logger.CkSimpleLogService;
import com.gomyck.util.log.logger.LogInfo;
import com.gomyck.util.serialize.CKJSON;
import com.gomyck.util.servlet.HttpServletRequestClone;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.multipart.MultipartFile;

public class CkLogger {
    private final String hostName = CkIp.getHostName();
    private final String hostIp = CkIp.getHostAddress();
    @Autowired(required=false)
    private CkLogService logService;
    @Autowired
    LoggerAdapter<HttpServletRequestClone, SimpleCkSessionUser> userInfoAdapter;
    private static final CkSimpleLogService simpleService = new CkSimpleLogService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void saveSysLog(ProceedingJoinPoint joinPoint, SysLog syslog, LogInfo logInfo, long time, Object result, String threadName, HttpServletRequestClone request) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (syslog == null) {
            return;
        }
        CkLogService sysLogService = this.logService;
        logInfo.setLogLevel(syslog.level());
        logInfo.setMainThread(threadName);
        logInfo.setOperation(syslog.value());
        if (result instanceof Throwable) {
            logInfo.setExecResult(CkLogger.getTrace((Throwable)result));
        } else {
            logInfo.setExecResult(CKJSON.getInstance().toJsonString(result));
        }
        logInfo.setModuleName(Arrays.asList(syslog.module()));
        logInfo.setCallSuccess(!(result instanceof Throwable));
        logInfo.setCreateTime(CkDate.now2Str("yyyy-MM-dd HH:mm:ss.SSS"));
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        logInfo.setMethodName(className + "." + methodName + "(): " + signature.getReturnType().getName());
        HashMap headers = new HashMap();
        if (syslog.headers() != null && syslog.headers().length > 0) {
            Arrays.stream(syslog.headers()).forEach(e -> headers.put(e, request.getHeader(e.toLowerCase())));
        }
        if (!headers.keySet().isEmpty()) {
            logInfo.setHeaders(CKJSON.getInstance().toJsonString(headers));
        }
        logInfo.setHost(request.getHeader("host"));
        logInfo.setOrigin(request.getHeader("origin"));
        logInfo.setReferer(request.getHeader("referer"));
        logInfo.setUserAgent(request.getHeader("user-agent"));
        List<String> parameterNames = CkLogger.getParameterNames(method);
        Object[] args = joinPoint.getArgs();
        HashMap<String, Object> paramInfo = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof ServletRequest || args[i] instanceof ServletResponse || args[i] instanceof MultipartFile) {
                paramInfo.put(parameterNames.get(i), args[i].getClass().getName());
                continue;
            }
            paramInfo.put(parameterNames.get(i), args[i]);
        }
        logInfo.setParamInfo(CKJSON.getInstance().toJsonString(paramInfo));
        try {
            logInfo.setClientIp(request.getRemoteAddr());
        }
        catch (Exception e2) {
            logInfo.setClientIp("UnKnow Ip");
        }
        logInfo.setHostName(this.hostName);
        logInfo.setHostIp(this.hostIp);
        logInfo.setRequestUrl(DataFilter.toString(request.getRequestURL()));
        logInfo.setToken(request.getToken());
        SimpleCkSessionUser userInfoByToken = this.userInfoAdapter.adaptIt(request);
        if (userInfoByToken != null) {
            String userId = userInfoByToken.getUserId();
            String userName = userInfoByToken.getUserName();
            logInfo.setUserId(userId);
            logInfo.setUserName(userName);
        } else {
            logInfo.setUserId("Anonymous");
            logInfo.setUserName("Anonymous");
        }
        logInfo.setExecTime(time + "");
        if (logInfo.getLogId() == null) {
            logInfo.setLogId(CkId.getSnowflakeId().toString());
        }
        if (sysLogService == null || syslog.useSimpleService()) {
            sysLogService = simpleService;
        }
        try {
            if (ObjectJudge.notNull((Object)syslog.mdc())) {
                MDC.put((String)syslog.mdc(), (String)logInfo.getLogId());
            }
            String execResult = "";
            if (!syslog.printResult()) {
                if (syslog.saveResult() && !(sysLogService instanceof CkSimpleLogService)) {
                    execResult = logInfo.getExecResult();
                }
                logInfo.setExecResult("");
            }
            simpleService.log(logInfo);
            if (!(sysLogService instanceof CkSimpleLogService)) {
                if (!syslog.saveResult()) {
                    logInfo.setExecResult(execResult);
                }
                sysLogService.log(logInfo);
            }
        }
        finally {
            if (ObjectJudge.notNull((Object)syslog.mdc())) {
                MDC.remove((String)syslog.mdc());
                MDC.clear();
            }
        }
    }

    private static List<String> getParameterNames(Executable executable) {
        return Arrays.stream(executable.getParameters()).map(Parameter::getName).collect(Collectors.toList());
    }

    public static String getTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }
}

