/*
 * Decompiled with CFR 0.152.
 */
package com.gomyck.util.mb;

import com.gomyck.util.spring.SpringContextAutoConfig;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.springframework.data.redis.core.RedisTemplate;

public class MybatisSecCache
implements Cache {
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final String KEY_EXPIRE_PROPERTY_NAME = "spring.redis.key.expire";
    private static int keyExpireSec;
    private static volatile RedisTemplate<String, Object> redisCache;
    private static final String CACHE_PREFIX = "mybatis_sec_cache_";
    private String id;

    public MybatisSecCache(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RedisTemplate<String, Object> getRedisCache() {
        if (redisCache != null) return redisCache;
        Class<MybatisSecCache> clazz = MybatisSecCache.class;
        synchronized (MybatisSecCache.class) {
            if (redisCache != null) return redisCache;
            String expire = SpringContextAutoConfig.getApplicationContext().getEnvironment().getProperty(KEY_EXPIRE_PROPERTY_NAME);
            keyExpireSec = Integer.parseInt(expire == null ? "3600" : expire);
            redisCache = (RedisTemplate)SpringContextAutoConfig.getBean("redisTemplate");
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisCache;
        }
    }

    public String getId() {
        return CACHE_PREFIX.concat(this.id);
    }

    public void putObject(Object key, Object value) {
        try {
            MybatisSecCache.getRedisCache().multi();
            MybatisSecCache.getRedisCache().boundHashOps((Object)this.getId()).put((Object)key.toString(), value);
            MybatisSecCache.getRedisCache().boundHashOps((Object)this.getId()).expire((long)keyExpireSec, TimeUnit.SECONDS);
            MybatisSecCache.getRedisCache().exec();
        }
        catch (Exception e) {
            MybatisSecCache.getRedisCache().discard();
            throw new RuntimeException(e);
        }
    }

    public Object getObject(Object key) {
        return MybatisSecCache.getRedisCache().boundHashOps((Object)this.getId()).get((Object)key.toString());
    }

    public Object removeObject(Object key) {
        return MybatisSecCache.getRedisCache().boundHashOps((Object)this.getId()).delete(new Object[]{key.toString()});
    }

    public void clear() {
        MybatisSecCache.getRedisCache().delete((Object)this.getId());
    }

    public int getSize() {
        return MybatisSecCache.getRedisCache().boundHashOps((Object)this.getId()).size() == null ? 0 : MybatisSecCache.getRedisCache().boundHashOps((Object)this.getId()).size().intValue();
    }

    public ReadWriteLock getReadWriteLock() {
        return READ_WRITE_LOCK;
    }
}

